/*
 * Copyright (c) 2008 TAKAHASHI Tomoyuki. All rights reserved.
 */
package jp.sourceforge.sowba.dtd2java.dtd;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * DTDELEMENTIuWFNgłB<br/>
 *
 * @author TAKAHASHI Tomoyuki
 *
 * <table border="1" cellpadding="3" cellspacing="0">
 * <tr bgcolor="#ccccff"><th>Ver.</th><th>t</th><th>ڍ</th></tr>
 * <tr><td>0.01</td><td>2008/01/05</td><td>VK쐬</td>
 * </table>
 */
public class ElementObject {

    private Map<String, AttributeObject> m_attrmap = new LinkedHashMap<String, AttributeObject>();;

    private Map<String, ElementObject> m_children = new LinkedHashMap<String, ElementObject>();

    private String m_keyAttributeName;

    private boolean m_hasBody = false;

    private String m_indicator;

    private final String m_name;

    private ElementObject m_parentElement;

    public ElementObject(final String name) {
        super();
        m_name = name;
    }

    public void addAttribute(String name, AttributeObject attr) {
        m_attrmap.put(name, attr);
    }

    public void addChild(String name, ElementObject elem) {
        elem.setParentElement(this);
        m_children.put(name, elem);
    }

    public AttributeObject[] getAttributes() {
        AttributeObject[] attrs = new AttributeObject[m_attrmap.values().size()];
        m_attrmap.values().toArray(attrs);
        return attrs;
    }

    public int getChildrenCount() {
        return m_children.size();
    }

    public ElementObject[] getChildren() {
        ElementObject[] elems = new ElementObject[m_children.values().size()];
        m_children.values().toArray(elems);
        return elems;
    }

    public String getIndicator() {
        if (m_indicator == null) {
            return "";
        } else {
            return m_indicator;
        }
    }

    public String getName() {
        return m_name;
    }

    public ElementObject getParentElement() {
        return m_parentElement;
    }

    public void setHasBody(boolean hasBody) {
        m_hasBody = hasBody;
    }

    public void setIndicator(String indecator) {
        if (indecator == null) {
            m_indicator = "";
        } else {
            m_indicator = indecator;
        }
    }

    public void setParentElement(ElementObject parentElement) {
        m_parentElement = parentElement;
    }

    public String getKeyAttributeName() {
        return m_keyAttributeName;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        m_keyAttributeName = keyAttributeName;
    }

    public boolean isHasBody() {
        return m_hasBody;
    }
}
