/*
 * Decompiled with CFR 0.152.
 */
package inter;

import com.nttdocomo.io.HttpConnection;
import com.nttdocomo.ui.IApplication;
import inter.BASICError;
import inter.IntVariable;
import inter.ProgLine;
import inter.StringVariable;
import inter.Variable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import ui.Console;

public class Environment {
    public Hashtable variables = new Hashtable();
    public boolean modified = false;
    public ProgLine first;

    public Variable getVar(String varName) {
        Variable res = this.getVarWithoutCreation(varName = varName.toUpperCase());
        if (res == null) {
            res = varName.endsWith("$") ? new StringVariable() : new IntVariable();
            this.variables.put(varName, res);
        }
        return res;
    }

    public Variable getVarWithoutCreation(String varName) {
        varName = varName.toUpperCase();
        return (Variable)this.variables.get(varName);
    }

    public void addLine(int ln, String content) throws BASICError {
        this.modified = true;
        if (content.length() == 0) {
            this.deleteLine(ln);
            return;
        }
        ProgLine p = new ProgLine();
        p.init(this, ln, content);
        if (this.first == null) {
            this.first = p;
            return;
        }
        if (ln < this.first.lineNo) {
            ProgLine of = this.first;
            this.first = p;
            p.next = of;
        } else if (ln == this.first.lineNo) {
            p.next = this.first.next;
            this.first = p;
        } else {
            ProgLine ins = this.first.findInsertion(ln);
            ProgLine.set(ins, p);
        }
    }

    private void deleteLine(int ln) throws BASICError {
        if (this.first == null) {
            this.error("UL");
        }
        if (this.first != null && this.first.lineNo == ln) {
            this.first = this.first.next;
        } else {
            ProgLine delPrev = this.first.findInsertion(ln);
            if (delPrev != null && delPrev.next != null && delPrev.next.lineNo == ln) {
                delPrev.next = delPrev.next.next;
            } else {
                this.error("UL");
            }
        }
        this.modified = true;
    }

    public void saveToScratchPad(int ofs) {
        try {
            DataOutputStream o = new DataOutputStream(Connector.openOutputStream((String)("scratchpad:///0;pos=" + ofs)));
            this.save(o);
            o.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String saveToNetwork(String name) {
        String msg = "Save Error";
        HttpConnection con = null;
        try {
            String url = String.valueOf(IApplication.getCurrentApp().getSourceURL()) + "upload.cgi?" + name;
            con = (HttpConnection)Connector.open((String)url, (int)3, (boolean)true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "text/plain");
            DataOutputStream out = new DataOutputStream(con.openOutputStream());
            this.save(out);
            out.close();
            con.connect();
            if (con.getResponseCode() == 200) {
                DataInputStream in = new DataInputStream(con.openInputStream());
                int res = in.read();
                msg = res == 48 ? "Save Complete" : "Save http error";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                msg = "Close Error";
            }
        }
        return msg;
    }

    public String loadFromNetwork(String name) {
        String msg = "Load Error";
        HttpConnection con = null;
        try {
            String url = String.valueOf(IApplication.getCurrentApp().getSourceURL()) + "download.cgi?" + name;
            con = (HttpConnection)Connector.open((String)url, (int)1, (boolean)true);
            con.setRequestMethod("GET");
            con.connect();
            if (con.getResponseCode() == 200) {
                DataInputStream in = new DataInputStream(con.openInputStream());
                int res = in.read();
                if (res == 48) {
                    this.load(in);
                    msg = "Load Complete";
                } else {
                    msg = "File not found";
                }
                in.close();
            }
        }
        catch (IOException e) {
            msg = "Load IO Error";
            e.printStackTrace();
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                msg = "Close Error";
            }
        }
        return msg;
    }

    public void loadFromScratchPad(int ofs) {
        try {
            DataInputStream o = new DataInputStream(Connector.openInputStream((String)("scratchpad:///0;pos=" + ofs)));
            this.load(o);
            o.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(DataOutputStream d) throws IOException {
        ProgLine cur = this.first;
        while (cur != null) {
            d.writeInt(cur.lineNo);
            d.writeUTF(cur.content);
            cur = cur.next;
        }
        d.writeInt(-1);
        this.modified = false;
    }

    public void load(DataInputStream i) throws IOException {
        this.variables.clear();
        int line = i.readInt();
        ProgLine cur = null;
        ProgLine oldF = this.first;
        while (line >= 0) {
            String content = i.readUTF();
            ProgLine r = new ProgLine();
            try {
                r.init(this, line, content);
            }
            catch (BASICError e) {
                Console.current.print(e + " in " + line);
            }
            if (cur == null) {
                this.first = r;
            } else {
                cur.next = r;
            }
            cur = r;
            int pline = line;
            line = i.readInt();
            if (line < 0 || line > pline) continue;
            Console.current.print("Empty File");
            this.first = oldF;
            break;
        }
        this.modified = false;
    }

    public void error(String errorCode) throws BASICError {
        throw new BASICError(errorCode);
    }
}

