/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.springframework.mail.javamail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.springframework.mail.javamail.MimeMessageHelper;

public class IntlMimeMessageHelper
extends MimeMessageHelper {
    protected static final String DEFAULT_CHARSET = "iso-2022-jp";
    protected String charset = "iso-2022-jp";
    protected boolean multipart = false;

    public IntlMimeMessageHelper(MimeMessage mimeMessage) throws MessagingException {
        super(mimeMessage);
        this.setHeader();
    }

    public IntlMimeMessageHelper(MimeMessage mimeMessage, String charset) throws MessagingException {
        super(mimeMessage);
        this.charset = charset;
        this.setHeader();
    }

    public IntlMimeMessageHelper(MimeMessage mimeMessage, boolean multipart) throws MessagingException {
        super(mimeMessage, multipart);
        this.multipart = multipart;
        this.setHeader();
    }

    public IntlMimeMessageHelper(MimeMessage mimeMessage, boolean multipart, String charset) throws MessagingException {
        super(mimeMessage, multipart);
        this.multipart = multipart;
        this.charset = charset;
        this.setHeader();
    }

    private void setHeader() throws MessagingException {
        this.getMimeMessage().setSentDate(new Date());
        if (this.charset.equalsIgnoreCase(DEFAULT_CHARSET)) {
            this.getMimeMessage().setHeader("Content-Transfer-Encoding", "7bit");
        }
    }

    public void setSubject(String subject) throws MessagingException {
        this.getMimeMessage().setSubject(subject, this.charset);
    }

    public void setText(final String text, boolean html) throws MessagingException {
        MimeMessage partToUse = null;
        MimeMultipart mimeMultipart = null;
        if (this.multipart) {
            try {
                mimeMultipart = (MimeMultipart)this.getMimeMessage().getContent();
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage());
            }
        }
        if (mimeMultipart != null) {
            BodyPart bodyPart = null;
            int i = 0;
            while (i < mimeMultipart.getCount()) {
                BodyPart bp = mimeMultipart.getBodyPart(i);
                if (bp.getFileName() == null) {
                    bodyPart = bp;
                }
                ++i;
            }
            if (bodyPart == null) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                bodyPart = mimeBodyPart;
            }
            partToUse = bodyPart;
        } else {
            partToUse = this.getMimeMessage();
        }
        if (html) {
            partToUse.setDataHandler(new DataHandler(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(text.getBytes());
                }

                public OutputStream getOutputStream() throws IOException {
                    throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
                }

                public String getContentType() {
                    return "text/html";
                }

                public String getName() {
                    return "text";
                }
            }));
        } else {
            this.getMimeMessage().setText(text, this.charset);
        }
    }
}

