package com.ozacc.springframework.mail.javamail;

import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;

import com.ozacc.springframework.mail.PlainMailMessage;

/**
 * 
 * @author Tomohiro Otsuka
 * @version $Id: IntlJavaMailSender.java,v 1.1 2004/02/11 06:58:46 otsuka Exp $
 */
public interface IntlJavaMailSender extends JavaMailSender {

	/**
	 * Send the given plain mail message.
	 * @param plainMessage
	 */
	public void send(PlainMailMessage plainMessage) throws MailException;

	/**
	 * Send the given array of plain mail messages in batch.
	 * @param plainMessages
	 */
	public void send(PlainMailMessage[] plainMessages) throws MailException;

}