package com.ozacc.springframework.mail.javamail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;

import com.ozacc.springframework.mail.PlainMailMessage;

/**
 *
 * @author Tomohiro Otsuka
 * @version $Id: IntlJavaMailSenderImpl.java,v 1.2 2004/02/24 10:31:57 otsuka Exp $
 */
public class IntlJavaMailSenderImpl extends JavaMailSenderImpl implements IntlJavaMailSender {

	protected final static String DEFAULT_CHARSET = "iso-2022-jp";
	protected String charset = DEFAULT_CHARSET;

	/**
	 * ʸɤ򥻥åȤޤ
	 * @param charset
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.IntlJavaMailSender#send(com.ozacc.springframework.mail.PlainMailMessage)
	 */
	public void send(PlainMailMessage plainMessage) throws MailException {
		send(new PlainMailMessage[] { plainMessage });
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.IntlJavaMailSender#send(com.ozacc.springframework.mail.PlainMailMessage[])
	 */
	public void send(PlainMailMessage[] plainMessages) throws MailException {
		try {
			List mimeMessages = new ArrayList();
			for (int i = 0; i < plainMessages.length; i++) {
				PlainMailMessage plainMessage = plainMessages[i];
				if (logger.isDebugEnabled())
					logger.debug(
						"Sending email using the following mail properties [" + plainMessage + "]");

				MimeMessage mimeMessage = createMimeMessage();
				setNamedFromAndTo(plainMessage, mimeMessage);
				assenbleHeader(plainMessage, mimeMessage);
				mimeMessages.add(mimeMessage);
			}
			send(
				(MimeMessage[])mimeMessages.toArray(new MimeMessage[mimeMessages.size()]),
				plainMessages);
		} catch (UnsupportedEncodingException ex) {
			throw new MailParseException(ex);
		} catch (MessagingException ex) {
			throw new MailParseException(ex);
		}
	}

	/**
	 * SimpleMailMessageη̾ʸꤵƤʸɤǥ󥳡ɤޤ
	 * ޤ򼨤Dateإå򥻥åȤޤ
	 * @see org.springframework.mail.MailSender#send(org.springframework.mail.SimpleMailMessage[])
	 */
	public void send(SimpleMailMessage[] simpleMessages) throws MailException {
		try {
			List mimeMessages = new ArrayList();
			for (int i = 0; i < simpleMessages.length; i++) {
				SimpleMailMessage simpleMessage = simpleMessages[i];
				if (logger.isDebugEnabled()) {
					logger.debug(
						"Creating MIME message using the following mail properties: "
							+ simpleMessage);
				}

				IntlMimeMessageHelper message =
					new IntlMimeMessageHelper(createMimeMessage(), charset);

				if (simpleMessage.getFrom() != null) {
					message.setFrom(simpleMessage.getFrom());
				}
				if (simpleMessage.getTo() != null) {
					message.setTo(simpleMessage.getTo());
				}
				if (simpleMessage.getCc() != null) {
					message.setCc(simpleMessage.getCc());
				}
				if (simpleMessage.getBcc() != null) {
					message.setBcc(simpleMessage.getBcc());
				}
				if (simpleMessage.getSubject() != null) {
					message.setSubject(simpleMessage.getSubject());
				}
				if (simpleMessage.getText() != null) {
					message.setText(simpleMessage.getText());
				}
				mimeMessages.add(message.getMimeMessage());
			}
			send(
				(MimeMessage[])mimeMessages.toArray(new MimeMessage[mimeMessages.size()]),
				simpleMessages);
		} catch (MessagingException ex) {
			throw new MailParseException(ex);
		}
	}

	protected void setNamedFromAndTo(PlainMailMessage plainMessage, MimeMessage mimeMessage)
		throws MessagingException, UnsupportedEncodingException, AddressException {

		if ((plainMessage.getFrom() != null) && (plainMessage.getFromName() != null)) {
			mimeMessage.setFrom(
				new InternetAddress(plainMessage.getFrom(), plainMessage.getFromName(), charset));
		} else if (plainMessage.getFrom() != null) {
			mimeMessage.setFrom(new InternetAddress(plainMessage.getFrom()));
		}

		if ((plainMessage.getTo() != null) && (plainMessage.getToName() != null)) {
			String[] to = plainMessage.getTo();
			String[] toName = plainMessage.getToName();
			if (to.length != toName.length)
				throw new IllegalStateException();

			for (int i = 0; i < to.length; i++) {
				mimeMessage.addRecipient(
					Message.RecipientType.TO,
					new InternetAddress(to[i], toName[i], charset));
			}
		} else if (plainMessage.getTo() != null) {
			String[] to = plainMessage.getTo();
			for (int i = 0; i < to.length; i++) {
				mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(to[i]));
			}
		}

	}

	protected void assenbleHeader(SimpleMailMessage simpleMessage, MimeMessage mimeMessage)
		throws MessagingException, AddressException {
		if (simpleMessage.getCc() != null) {
			for (int j = 0; j < simpleMessage.getCc().length; j++) {
				mimeMessage.addRecipient(
					Message.RecipientType.CC,
					new InternetAddress(simpleMessage.getCc()[j]));
			}
		}
		if (simpleMessage.getBcc() != null) {
			for (int j = 0; j < simpleMessage.getBcc().length; j++) {
				mimeMessage.addRecipient(
					Message.RecipientType.BCC,
					new InternetAddress(simpleMessage.getBcc()[j]));
			}
		}
		if (simpleMessage.getSubject() != null) {
			mimeMessage.setSubject(simpleMessage.getSubject(), charset);
		}
		if (simpleMessage.getText() != null) {
			mimeMessage.setText(simpleMessage.getText(), charset);
		}

		// 򥻥å
		mimeMessage.setSentDate(new Date());
		// إåˡContent-Transfer-Encoding: 7bitפ򥻥å
		if (charset.equalsIgnoreCase("iso-2022-jp"))
			mimeMessage.setHeader("Content-Transfer-Encoding", "7bit");
	}
}