/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.springframework.mail.javamail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.springframework.mail.javamail.MimeMessageHelper;

public class IntlMimeMessageHelper
extends MimeMessageHelper {
    protected static final String JIS_ENCODING = "ISO-2022-JP";
    protected boolean multipart = false;

    public IntlMimeMessageHelper(MimeMessage mimeMessage) throws MessagingException {
        super(mimeMessage);
        this.setDate();
    }

    public IntlMimeMessageHelper(MimeMessage mimeMessage, String encoding) throws MessagingException {
        super(mimeMessage, encoding);
        this.setDate();
    }

    public IntlMimeMessageHelper(MimeMessage mimeMessage, boolean multipart) throws MessagingException {
        super(mimeMessage, multipart);
        this.multipart = multipart;
        this.setDate();
    }

    public IntlMimeMessageHelper(MimeMessage mimeMessage, boolean multipart, String encoding) throws MessagingException {
        super(mimeMessage, multipart, encoding);
        this.multipart = multipart;
        this.setDate();
    }

    protected void setDate() throws MessagingException {
        this.getMimeMessage().setSentDate(new Date());
    }

    public void setSubject(String subject) throws MessagingException {
        if (this.getEncoding() != null) {
            if (this.getEncoding().equalsIgnoreCase(JIS_ENCODING)) {
                try {
                    this.getMimeMessage().setSubject(MimeUtility.encodeText((String)subject, (String)JIS_ENCODING, (String)"B"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessagingException(e.getMessage());
                }
            } else {
                this.getMimeMessage().setSubject(subject, this.getEncoding());
            }
        } else {
            this.getMimeMessage().setSubject(subject);
        }
    }

    public void setText(final String text, boolean html) throws MessagingException {
        MimeMultipart mimeMultipart = this.getMimeMultipart();
        MimeMessage partToUse = null;
        if (mimeMultipart != null) {
            MimeBodyPart bodyPart = null;
            for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                BodyPart bp = mimeMultipart.getBodyPart(i);
                if (bp.getFileName() != null) continue;
                bodyPart = (MimeBodyPart)bp;
            }
            if (bodyPart == null) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                bodyPart = mimeBodyPart;
            }
            partToUse = bodyPart;
        } else {
            partToUse = this.getMimeMessage();
        }
        if (html) {
            partToUse.setDataHandler(new DataHandler(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(IntlMimeMessageHelper.this.getEncoding() != null ? text.getBytes(IntlMimeMessageHelper.this.getEncoding()) : text.getBytes());
                }

                public OutputStream getOutputStream() throws IOException {
                    throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
                }

                public String getContentType() {
                    return IntlMimeMessageHelper.this.getEncoding() == null ? "text/html" : "text/html; charset=" + IntlMimeMessageHelper.this.getEncoding();
                }

                public String getName() {
                    return "text";
                }
            }));
        } else if (this.getEncoding() != null) {
            partToUse.setText(text, this.getEncoding());
            if (this.getEncoding().equalsIgnoreCase(JIS_ENCODING)) {
                partToUse.setHeader("Content-Transfer-Encoding", "7bit");
            }
        } else {
            partToUse.setText(text);
        }
    }

    private MimeMultipart getMimeMultipart() throws MessagingException {
        MimeMultipart mimeMultipart = null;
        if (this.multipart) {
            try {
                mimeMultipart = (MimeMultipart)this.getMimeMessage().getContent();
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage());
            }
        }
        return mimeMultipart;
    }

    public void addAttachment(String attachmentFilename, DataSource dataSource) throws MessagingException {
        MimeMultipart mimeMultipart = this.getMimeMultipart();
        if (mimeMultipart == null) {
            throw new IllegalStateException("Cannot add attachment - not in multipart mode");
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        try {
            bodyPart.setFileName(MimeUtility.encodeText((String)attachmentFilename, (String)JIS_ENCODING, (String)"B"));
        }
        catch (UnsupportedEncodingException e) {
            throw new MessagingException(e.getMessage());
        }
        bodyPart.setDataHandler(new DataHandler(dataSource));
        mimeMultipart.addBodyPart((BodyPart)bodyPart);
    }
}

