package com.ozacc.springframework.mail.javamail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

import com.ozacc.springframework.mail.PlainMailMessage;

/**
 * IntlJavaMailSender󥿡եμ饹
 * <p>
 * JavaMailSenderImplȰۤʤꡢDateإå򥻥åȤޤ<br>
 * ޤʸɤ꤬ǽǤǥեȤʸɤϡiso-2022-jpס
 * <pre>
 * &lt;bean id="mailSender" class="com.ozacc.springframework.mail.javamail.IntlJavaMailSenderImpl"&gt;
 *     &lt;property name="charset"&gt;iso-2022-jp&lt;/property&gt;
 *     &lt;property name="host"&gt;smtp.example.com&lt;/property&gt;
 * &lt;/bean&gt;
 * </pre>
 * 
 * @author Tomohiro Otsuka
 * @version $Id: IntlJavaMailSenderImpl.java,v 1.1 2004/08/02 20:39:06 otsuka Exp $
 */
public class IntlJavaMailSenderImpl extends JavaMailSenderImpl implements IntlJavaMailSender {

	protected final static String JIS_ENCODING = "iso-2022-jp";

	protected String charset = JIS_ENCODING;

	/**
	 * ʸɤ򥻥åȤޤ
	 * 
	 * @param charset
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.IntlJavaMailSender#send(com.ozacc.springframework.mail.PlainMailMessage)
	 */
	public void send(PlainMailMessage plainMessage) throws MailException {
		send(new PlainMailMessage[] { plainMessage });
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.IntlJavaMailSender#send(com.ozacc.springframework.mail.PlainMailMessage[])
	 */
	public void send(PlainMailMessage[] plainMessages) throws MailException {
		try {
			List mimeMessages = new ArrayList();
			for (int i = 0; i < plainMessages.length; i++) {
				PlainMailMessage plainMessage = plainMessages[i];
				if (logger.isDebugEnabled())
					logger.debug(
						"Sending email using the following mail properties [" + plainMessage + "]");

				MimeMessageHelper message =
					new IntlMimeMessageHelper(createMimeMessage(), this.charset);
				assembleMailHeader(plainMessage, message);
				setText(plainMessage, message);

				mimeMessages.add(message.getMimeMessage());
			}
			send(
				(MimeMessage[])mimeMessages.toArray(new MimeMessage[mimeMessages.size()]),
				plainMessages);
		} catch (UnsupportedEncodingException ex) {
			throw new MailParseException(ex);
		} catch (MessagingException ex) {
			throw new MailParseException(ex);
		}
	}

	/**
	 * ᡼ʸ򥻥åȤޤ
	 * <p>
	 * :<br>
	 * ʸκǸ˲ԤʤMozillaϤΥ᡼顼ǺǽԤܸ줬
	 * ʸƤޤᡢmessage.setTextΰǺǸ\nɲäƤ롣
	 * 
	 * @param plainMessage
	 * @param message
	 * @throws MessagingException
	 */
	protected void setText(PlainMailMessage plainMessage, MimeMessageHelper message)
		throws MessagingException {
		if (plainMessage.getText() != null) {
			message.setText(plainMessage.getText() + "\n");
		}
	}

	/**
	 * MimeMessageȤΩƤޤ
	 * 
	 * @param plainMessage
	 * @param message
	 * @throws MessagingException
	 * @throws UnsupportedEncodingException
	 * @throws IllegalStateException
	 */
	protected void assembleMailHeader(PlainMailMessage plainMessage, MimeMessageHelper message)
		throws MessagingException, UnsupportedEncodingException, IllegalStateException {
		// From
		if (plainMessage.getFrom() != null && plainMessage.getFromName() != null) {
			message.setFrom(plainMessage.getFrom(), plainMessage.getFromName());
		} else if (plainMessage.getFrom() != null) {
			message.setFrom(plainMessage.getFrom());
		}
		// To
		if (plainMessage.getTo() != null && plainMessage.getToName() != null) {
			String[] to = plainMessage.getTo();
			String[] personal = plainMessage.getToName();
			if (to.length != personal.length)
				throw new IllegalStateException(
					"Υ᡼륢ɥ쥹Ȱ̾οפƤޤ ["
						+ to.length
						+ " emails / "
						+ personal.length
						+ " names]");
			for (int j = 0; j < to.length; j++) {
				message.addTo(to[j], personal[j]);
			}
		} else if (plainMessage.getTo() != null) {
			String[] to = plainMessage.getTo();
			for (int j = 0; j < to.length; j++) {
				message.addTo(to[j]);
			}
		}
		// Cc
		if (plainMessage.getCc() != null) {
			message.setCc(plainMessage.getCc());
		}
		// Bcc
		if (plainMessage.getBcc() != null) {
			message.setBcc(plainMessage.getBcc());
		}
		// Subject
		if (plainMessage.getSubject() != null) {
			message.setSubject(plainMessage.getSubject());
		}
	}

	/**
	 * SimpleMailMessageη̾ʸꤵƤʸɤǥ󥳡ɤޤ
	 * ޤ򼨤Dateإå򥻥åȤޤ
	 * 
	 * @see org.springframework.mail.MailSender#send(org.springframework.mail.SimpleMailMessage[])
	 */
	public void send(SimpleMailMessage[] simpleMessages) throws MailException {
		try {
			List mimeMessages = new ArrayList();
			for (int i = 0; i < simpleMessages.length; i++) {
				SimpleMailMessage simpleMessage = simpleMessages[i];
				if (logger.isDebugEnabled()) {
					logger.debug(
						"Creating new MIME message using the following mail properties: "
							+ simpleMessage);
				}

				MimeMessageHelper message =
					new IntlMimeMessageHelper(createMimeMessage(), this.charset);

				if (simpleMessage.getFrom() != null) {
					message.setFrom(simpleMessage.getFrom());
				}
				if (simpleMessage.getTo() != null) {
					message.setTo(simpleMessage.getTo());
				}
				if (simpleMessage.getCc() != null) {
					message.setCc(simpleMessage.getCc());
				}
				if (simpleMessage.getBcc() != null) {
					message.setBcc(simpleMessage.getBcc());
				}
				if (simpleMessage.getSubject() != null) {
					message.setSubject(simpleMessage.getSubject());
				}
				if (simpleMessage.getText() != null) {
					message.setText(simpleMessage.getText());
				}

				mimeMessages.add(message.getMimeMessage());
			}
			send(
				(MimeMessage[])mimeMessages.toArray(new MimeMessage[mimeMessages.size()]),
				simpleMessages);
		} catch (MessagingException ex) {
			throw new MailParseException(ex);
		}
	}

}