/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class MimeMessageBuilder {
    private MimeMessage message;
    private String charset = "ISO-2022-JP";

    public MimeMessageBuilder(MimeMessage mimeMessage) {
        this.message = mimeMessage;
    }

    public MimeMessageBuilder(MimeMessage mimeMessage, String charset) {
        this.message = mimeMessage;
        this.charset = charset;
    }

    public MimeMessage getMimeMessage() {
        return this.message;
    }

    public void buildMimeMessage(Mail mail) throws UnsupportedEncodingException, MessagingException {
        this.setFrom(mail);
        this.setSubject(mail);
        this.setText(mail);
        this.setTo(mail);
        this.setCc(mail);
        this.setBcc(mail);
        this.setReplyTo(mail);
        this.setXHeaders(mail);
        this.setImportance(mail);
    }

    private void setXHeaders(Mail mail) throws MessagingException {
        Map headers = mail.getXHeaders();
        if (headers == null) {
            return;
        }
        Iterator itr = headers.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String value = (String)headers.get(key);
            this.message.setHeader(key, value);
        }
    }

    private void setImportance(Mail mail) throws MessagingException {
        if (mail.getImportance() != null) {
            this.message.setHeader("Importance", mail.getImportance());
            int level = 3;
            if ("high".equals(mail.getImportance())) {
                level = 1;
            } else if ("low".equals(mail.getImportance())) {
                level = 5;
            }
            this.message.setHeader("X-Priority", String.valueOf(level));
        }
    }

    private void setReplyTo(Mail mail) throws MessagingException {
        if (mail.getReplyTo() != null) {
            this.message.setReplyTo((Address[])new InternetAddress[]{mail.getReplyTo()});
        }
    }

    private void setBcc(Mail mail) throws MessagingException {
        if (mail.getBcc().length > 0) {
            this.message.setRecipients(Message.RecipientType.BCC, (Address[])mail.getBcc());
        }
    }

    private void setCc(Mail mail) throws MessagingException {
        if (mail.getCc().length > 0) {
            this.message.setRecipients(Message.RecipientType.CC, (Address[])mail.getCc());
        }
    }

    private void setTo(Mail mail) throws MessagingException {
        if (mail.getTo().length > 0) {
            this.message.setRecipients(Message.RecipientType.TO, (Address[])mail.getTo());
        }
    }

    private void setText(Mail mail) throws MessagingException {
        if (this.charset != null) {
            this.message.setText(mail.getText(), this.charset);
            if (this.charset.equalsIgnoreCase("ISO-2022-JP")) {
                this.message.setHeader("Content-Transfer-Encoding", "7bit");
            }
        } else {
            this.message.setText(mail.getText());
        }
    }

    private void setSubject(Mail mail) throws UnsupportedEncodingException, MessagingException {
        if (this.charset != null) {
            if (this.charset.equalsIgnoreCase("ISO-2022-JP")) {
                this.message.setSubject(MimeUtility.encodeText((String)mail.getSubject(), (String)this.charset, (String)"B"));
            } else {
                this.message.setSubject(mail.getSubject(), this.charset);
            }
        } else {
            this.message.setSubject(mail.getSubject());
        }
    }

    private void setFrom(Mail mail) throws MessagingException {
        this.message.setFrom((Address)mail.getFrom());
    }
}

