/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailAuthenticationException;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.MailSendException;
import com.ozacc.mail.SendMail;
import com.ozacc.mail.impl.MimeMessageBuilder;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendMailImpl
implements SendMail {
    private static Log log = LogFactory.getLog((Class)(class$com$ozacc$mail$impl$SendMailImpl == null ? (class$com$ozacc$mail$impl$SendMailImpl = SendMailImpl.class$("com.ozacc.mail.impl.SendMailImpl")) : class$com$ozacc$mail$impl$SendMailImpl));
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HOST = "localhost";
    public static final String JIS_CHARSET = "ISO-2022-JP";
    private static final String RETURN_PATH_KEY = "mail.smtp.from";
    private String protocol = "smtp";
    private String host = "localhost";
    private int port = -1;
    private String username;
    private String password;
    private String charset = "ISO-2022-JP";
    private String returnPath;
    static /* synthetic */ Class class$com$ozacc$mail$impl$SendMailImpl;

    public void send(Mail mail) throws MailException {
        this.send(new Mail[]{mail});
    }

    public void send(Mail[] mails) throws MailException {
        MimeMessageWrapper[] mmws = new MimeMessageWrapper[mails.length];
        Session session = Session.getInstance((Properties)new Properties());
        for (int i = 0; i < mails.length; ++i) {
            Mail mail = mails[i];
            MimeMessage message = this.createMimeMessage(session);
            MimeMessageBuilder builder = new MimeMessageBuilder(message);
            try {
                builder.buildMimeMessage(mail);
            }
            catch (UnsupportedEncodingException e) {
                throw new MailBuildException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002", e);
            }
            catch (MessagingException e) {
                throw new MailBuildException("MimeMessage\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
            String returnPath = mail.getReturnPath() != null ? mail.getReturnPath().getAddress() : this.returnPath;
            mmws[i] = new MimeMessageWrapper(message, returnPath);
        }
        this.processSend(mmws);
    }

    public void send(MimeMessage message) throws MailException {
        this.send(new MimeMessage[]{message});
    }

    public void send(MimeMessage[] messages) throws MailException {
        MimeMessageWrapper[] mmws = new MimeMessageWrapper[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            mmws[i] = new MimeMessageWrapper(messages[i], this.returnPath);
        }
        this.processSend(mmws);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSend(MimeMessageWrapper[] mmws) throws MailException {
        Session session = Session.getInstance((Properties)new Properties());
        Transport transport = null;
        try {
            try {
                log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3057\u307e\u3059\u3002"));
                transport = session.getTransport(this.protocol);
                transport.connect(this.host, this.port, this.username, this.password);
                for (int i = 0; i < mmws.length; ++i) {
                    MimeMessage mimeMessage = mmws[i].getMimeMessage();
                    String returnPath = mmws[i].getReturnPath();
                    if (returnPath != null) {
                        ((Hashtable)session.getProperties()).put(RETURN_PATH_KEY, returnPath);
                        log.debug((Object)("Return-Path[" + returnPath + "]\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002"));
                    }
                    mimeMessage.setSentDate(new Date());
                    mimeMessage.saveChanges();
                    log.debug((Object)"\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3059\u3002");
                    transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
                    log.debug((Object)"\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002");
                    if (returnPath == null) continue;
                    ((Hashtable)session.getProperties()).remove(RETURN_PATH_KEY);
                    log.debug((Object)"Return-Path\u8a2d\u5b9a\u3092\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f\u3002");
                }
                Object var8_9 = null;
                if (transport == null) return;
            }
            catch (AuthenticationFailedException ex) {
                log.error((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3078\u306e\u63a5\u7d9a\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)ex);
                throw new MailAuthenticationException(ex);
            }
            catch (MessagingException ex) {
                log.error((Object)"\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
                throw new MailSendException("\u30e1\u30fc\u30eb\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (transport == null) throw throwable;
            if (!transport.isConnected()) throw throwable;
            log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3059\u3002"));
            try {
                transport.close();
                throw throwable;
            }
            catch (MessagingException e) {
                log.error((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)e);
                throw new MailException("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
        if (!transport.isConnected()) return;
        log.debug((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u307e\u3059\u3002"));
        try {}
        catch (MessagingException e) {
            log.error((Object)("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002"), (Throwable)e);
            throw new MailException("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        transport.close();
    }

    private MimeMessage createMimeMessage(Session session) {
        return new MimeMessage(session);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MimeMessageWrapper {
        private MimeMessage mimeMessage;
        private String returnPath;

        public MimeMessageWrapper(MimeMessage mimeMessage, String returnPath) {
            this.mimeMessage = mimeMessage;
            this.returnPath = returnPath;
        }

        public MimeMessage getMimeMessage() {
            return this.mimeMessage;
        }

        public String getReturnPath() {
            return this.returnPath;
        }
    }
}

