package com.ozacc.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;

import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

/**
 * XMLե뤫Mail֥Ȥ륯饹
 * 
 * @author Tomohiro Otsuka
 * @version $Id$
 */
public class XMLMailBuilder {

	/**
	 * 󥹥ȥ饯
	 */
	public XMLMailBuilder() {}

	/**
	 * ꤵ줿饹ѥXMLե뤫Mail֥Ȥޤ
	 * 
	 * @param classPath ᡼Ƥ򵭽ҤXMLեΥѥ
	 * @return 줿Mail֥
	 * @throws MailBuildException Mail֥Ȥ˼Ԥ
	 */
	public Mail buildMail(String classPath) throws MailBuildException {
		Document doc = getDocumentFromClassPath(classPath);
		return build(doc);
	}

	/**
	 * ꤵ줿饹ѥXMLե뤫Mail֥Ȥޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param classPath ᡼Ƥ򵭽ҤXMLեΥѥ
	 * @param context VelocityContext
	 * @return 줿Mail֥
	 * @throws MailBuildException Mail֥Ȥ˼Ԥ
	 */
	public Mail buildMail(String classPath, VelocityContext context) throws MailBuildException {
		Document doc = getDocumentFromClassPath(classPath);
		try {
			return build(doc, context);
		} catch (Exception e) {
			throw new MailBuildException("᡼˼Ԥޤ", e);
		}
	}

	/**
	 * ꤵ줿XMLե뤫Mail֥Ȥޤ
	 * 
	 * @param file ᡼Ƥ򵭽ҤXMLե
	 * @return 줿Mail֥
	 * @throws MailBuildException Mail֥Ȥ˼Ԥ
	 */
	public Mail buildMail(File file) throws MailBuildException {
		Document doc = getDocumentFromFile(file);
		return build(doc);
	}

	/**
	 * ꤵ줿XMLե뤫Mail֥Ȥޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param file ᡼Ƥ򵭽ҤXMLե
	 * @param context VelocityContext
	 * @return 줿Mail֥
	 * @throws MailBuildException Mail֥Ȥ˼Ԥ
	 */
	public Mail buildMail(File file, VelocityContext context) throws MailBuildException {
		Document doc = getDocumentFromFile(file);
		try {
			return build(doc, context);
		} catch (Exception e) {
			throw new MailBuildException("᡼˼Ԥޤ", e);
		}
	}

	/**
	 * ꤵ줿饹ѥΥեɤ߹ǡXMLɥȤޤ
	 * 
	 * @param classPath
	 * @return JDOM Document
	 */
	private Document getDocumentFromClassPath(String classPath) throws MailBuildException {
		InputStream is = getClass().getResourceAsStream(classPath);
		SAXBuilder builder = new SAXBuilder();
		Document doc;
		try {
			doc = builder.build(is);
			is.close();
		} catch (JDOMException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ", e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}
		return doc;
	}

	/**
	 * ꤵ줿եɤ߹ǡXMLɥȤޤ
	 * 
	 * @param file
	 * @return JDOM Document
	 */
	private Document getDocumentFromFile(File file) {
		SAXBuilder builder = new SAXBuilder();
		Document doc;
		try {
			doc = builder.build(file);
		} catch (JDOMException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ", e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}
		return doc;
	}

	/**
	 * XMLɥȤMail֥Ȥޤ
	 * 
	 * @param doc
	 * @return Mail
	 */
	private Mail build(Document doc) {
		Element root = doc.getRootElement();

		Mail mail = new Mail();
		setFrom(root, mail);
		setRecipients(root, mail);
		setSubject(root, mail);
		setBody(root, mail);
		setReplyTo(root, mail);
		setReturnPath(root, mail);

		return mail;
	}

	/**
	 * VelocityContextXMLɥȤޡMail֥Ȥޤ
	 * 
	 * @param context
	 * @param doc
	 * @return Mail
	 * 
	 * @throws Exception
	 * @throws ParseErrorException
	 * @throws MethodInvocationException
	 * @throws ResourceNotFoundException
	 * @throws IOException
	 * @throws JDOMException 
	 */
	private Mail build(Document doc, VelocityContext context) throws Exception,
																ParseErrorException,
																MethodInvocationException,
																ResourceNotFoundException,
																IOException, JDOMException {
		XMLOutputter output = new XMLOutputter();
		String xmlContent = output.outputString(doc);

		Velocity.init();
		StringWriter w = new StringWriter();
		Velocity.evaluate(context, w, "xmlMail", xmlContent);
		StringReader reader = new StringReader(w.toString());

		SAXBuilder builder = new SAXBuilder();
		Document doc2 = builder.build(reader);

		return build(doc2);
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setReturnPath(Element root, Mail mail) {
		Element returnPathElem = root.getChild("returnPath");
		if (returnPathElem != null && returnPathElem.getAttributeValue("email") != null) {
			mail.setReturnPath(returnPathElem.getAttributeValue("email"));
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setReplyTo(Element root, Mail mail) {
		Element replyToElem = root.getChild("replyTo");
		if (replyToElem != null && replyToElem.getAttributeValue("email") != null) {
			mail.setReplyTo(replyToElem.getAttributeValue("email"));
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setBody(Element root, Mail mail) {
		Element bodyElem = root.getChild("body");
		if (bodyElem != null) {
			mail.setText(bodyElem.getTextTrim());
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setSubject(Element root, Mail mail) {
		Element subjectElem = root.getChild("subject");
		if (subjectElem != null) {
			mail.setSubject(subjectElem.getTextTrim());
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setRecipients(Element root, Mail mail) {
		Element recipientsElem = root.getChild("recipients");
		if (recipientsElem == null) {
			return;
		}

		List recipientElemList = recipientsElem.getChildren();
		for (int i = 0, max = recipientElemList.size(); i < max; i++) {
			Element e = (Element)recipientElemList.get(i);
			if ("to".equals(e.getName())) { // to
				if (e.getAttributeValue("email") != null) {
					if (e.getAttributeValue("name") != null) {
						mail.addTo(e.getAttributeValue("email"), e.getAttributeValue("name"));
					} else {
						mail.addTo(e.getAttributeValue("email"));
					}
				}
			} else if ("cc".equals(e.getName())) { // cc
				if (e.getAttributeValue("email") != null) {
					if (e.getAttributeValue("name") != null) {
						mail.addCc(e.getAttributeValue("email"), e.getAttributeValue("name"));
					} else {
						mail.addCc(e.getAttributeValue("email"));
					}
				}
			} else {
				if (e.getAttributeValue("email") != null) { // bcc
					mail.addBcc(e.getAttributeValue("email"));
				}
			}
		}
	}

	/**
	 * @param root
	 * @param mail 
	 */
	private void setFrom(Element root, Mail mail) {
		Element fromElem = root.getChild("from");
		if (fromElem != null && fromElem.getAttributeValue("email") != null) {
			if (fromElem.getAttributeValue("name") != null) {
				mail.setFrom(fromElem.getAttributeValue("email"), fromElem
						.getAttributeValue("name"));
			} else {
				mail.setFrom(fromElem.getAttributeValue("email"));
			}
		}
	}

}