package com.ozacc.mail.impl;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;

import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailAuthenticationException;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.MailSendException;
import com.ozacc.mail.SendMail;

/**
 * SendMail󥿡եμ饹
 * 
 * @author Tomohiro Otsuka
 * @version $Id$
 */
public class SendMailImpl implements SendMail {

	private static Log log = LogFactory.getLog(SendMailImpl.class);

	/** smtp */
	public static final String DEFAULT_PROTOCOL = "smtp";

	/** -1 */
	public static final int DEFAULT_PORT = -1;

	/** localhost */
	public static final String DEFAULT_HOST = "localhost";

	/** ISO-2022-JP */
	public static final String JIS_CHARSET = "ISO-2022-JP";

	private static final String RETURN_PATH_KEY = "mail.smtp.from";

	private String protocol = DEFAULT_PROTOCOL;

	private String host = DEFAULT_HOST;

	private int port = DEFAULT_PORT;

	private String username;

	private String password;

	private String charset = JIS_CHARSET;

	private String returnPath;

	/**
	 * @see com.ozacc.mail.SendMail#send(com.ozacc.mail.Mail)
	 */
	public void send(Mail mail) throws MailException {
		send(new Mail[] { mail });
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(com.ozacc.mail.Mail[])
	 */
	public void send(Mail[] mails) throws MailException {
		MimeMessageWrapper[] mmws = new MimeMessageWrapper[mails.length];
		Session session = Session.getInstance(new Properties());
		for (int i = 0; i < mails.length; i++) {
			Mail mail = mails[i];

			// MimeMessage
			MimeMessage message = createMimeMessage(session);
			MimeMessageBuilder builder = new MimeMessageBuilder(message);
			try {
				builder.buildMimeMessage(mail);
			} catch (UnsupportedEncodingException e) {
				throw new MailBuildException("ݡȤƤʤʸɤꤵޤ", e);
			} catch (MessagingException e) {
				throw new MailBuildException("MimeMessage˼Ԥޤ", e);
			}

			// Return-Path
			String returnPath;
			if (mail.getReturnPath() != null) {
				returnPath = mail.getReturnPath().getAddress();
			} else {
				returnPath = this.returnPath;
			}

			mmws[i] = new MimeMessageWrapper(message, returnPath);
		}
		processSend(mmws);
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(javax.mail.internet.MimeMessage)
	 */
	public void send(MimeMessage message) throws MailException {
		send(new MimeMessage[] { message });
	}

	/**
	 * @see com.ozacc.mail.SendMail#send(javax.mail.internet.MimeMessage[])
	 */
	public void send(MimeMessage[] messages) throws MailException {
		MimeMessageWrapper[] mmws = new MimeMessageWrapper[messages.length];
		for (int i = 0; i < messages.length; i++) {
			mmws[i] = new MimeMessageWrapper(messages[i], returnPath);
		}
		processSend(mmws);
	}

	private void processSend(MimeMessageWrapper[] mmws) throws MailException {

		Session session = Session.getInstance(new Properties());

		Transport transport = null;
		try {
			// SMTPФ³
			log.debug("SMTP[" + host + "]³ޤ");

			transport = session.getTransport(protocol);
			transport.connect(host, port, username, password);

			for (int i = 0; i < mmws.length; i++) {
				MimeMessage mimeMessage = mmws[i].getMimeMessage();
				String returnPath = mmws[i].getReturnPath();

				// Return-Path򥻥å
				if (returnPath != null) {
					session.getProperties().put(RETURN_PATH_KEY, returnPath);
					log.debug("Return-Path[" + returnPath + "]ꤷޤ");
				}

				// 򥻥å
				mimeMessage.setSentDate(new Date());
				mimeMessage.saveChanges();
				// 
				log.debug("᡼ޤ");
				transport.sendMessage(mimeMessage, mimeMessage.getAllRecipients());
				log.debug("᡼ޤ");

				// Return-Path
				if (returnPath != null) {
					session.getProperties().remove(RETURN_PATH_KEY);
					log.debug("Return-Path򥯥ꥢޤ");
				}
			}
		} catch (AuthenticationFailedException ex) {
			log.error("SMTP[" + host + "]ؤ³ǧڤ˼Ԥޤ", ex);
			throw new MailAuthenticationException(ex);
		} catch (MessagingException ex) {
			log.error("᡼˼Ԥޤ", ex);
			throw new MailSendException("᡼˼Ԥޤ", ex);
		} finally {
			if (transport != null && transport.isConnected()) {
				log.debug("SMTP[" + host + "]Ȥ³Ǥޤ");
				try {
					// SMTPФȤ³
					transport.close();
				} catch (MessagingException e) {
					log.error("SMTP[" + host + "]Ȥ³Ǥ˼Ԥޤ", e);
					throw new MailException("SMTP[" + host + "]Ȥ³Ǥ˼Ԥޤ");
				}
			}
		}

	}

	/**
	 * MimeMessage֥Ȥޤ
	 * 
	 * @return MimeMessage֥
	 */
	private MimeMessage createMimeMessage(Session session) {
		return new MimeMessage(session);
	}

	/**
	 * 󥳡ǥ󥰤˻Ѥʸɤ֤ޤ
	 * 
	 * @return 󥳡ǥ󥰤˻Ѥʸ
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * ᡼η̾ʸΥ󥳡ǥ󥰤˻Ѥʸɤꤷޤ
	 * ǥեȤ ISO-2022-JP Ǥ
	 * <p>
	 * ܸĶѤ̾ѹɬפϤޤ
	 * 
	 * @param charset 󥳡ǥ󥰤˻Ѥʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * åȤ줿SMTPФΥۥ̾ޤIPɥ쥹֤ޤ
	 * 
	 * @return SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public String getHost() {
		return host;
	}

	/**
	 * SMTPФΥۥ̾ޤIPɥ쥹򥻥åȤޤ
	 * ǥեȤ localhost Ǥ
	 * 
	 * @param host SMTPФΥۥ̾ޤIPɥ쥹
	 */
	public void setHost(String host) {
		this.host = host;
	}

	/**
	 * @return SMTPǧڥѥ
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * SMTPФ³ǧڤɬפʾ˥ѥɤ򥻥åȤޤ
	 * 
	 * @param password SMTPǧڥѥ
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return SMTPФΥݡֹ
	 */
	public int getPort() {
		return port;
	}

	/**
	 * SMTPФΥݡֹ򥻥åȤޤ
	 * 
	 * @param port SMTPФΥݡֹ
	 */
	public void setPort(int port) {
		this.port = port;
	}

	/**
	 * @return Returns the protocol.
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @param protocol The protocol to set.
	 */
	public void setProtocol(String protocol) {
		this.protocol = protocol;
	}

	/**
	 * @return Return-Pathɥ쥹
	 */
	public String getReturnPath() {
		return returnPath;
	}

	/**
	 * Return-Pathɥ쥹򥻥åȤޤ
	 * <p>
	 * Mail󥹥󥹤˻ꤵ줿Fromɥ쥹ʳΥɥ쥹Return-PathȤ˻Ѥޤ
	 * ǥåȤ줿Return-PathꡢMail󥹥󥹤˥åȤ줿Return-Pathͥ褵ޤ
	 * 
	 * @param returnPath Return-Pathɥ쥹
	 */
	public void setReturnPath(String returnPath) {
		this.returnPath = returnPath;
	}

	/**
	 * @return SMTPǧڥ桼̾
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * SMTPФ³ǧڤɬפʾ˥桼̾򥻥åȤޤ
	 * 
	 * @param username SMTPǧڥ桼̾
	 */
	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * MimeMessage󥹥󥹤ȡΥ᡼бReturn-Pathåפ륯饹
	 * 
	 * @author Tomohiro Otsuka
	 * @version $Id$
	 */
	private static class MimeMessageWrapper {

		private MimeMessage mimeMessage;

		private String returnPath;

		public MimeMessageWrapper(MimeMessage mimeMessage, String returnPath) {
			this.mimeMessage = mimeMessage;
			this.returnPath = returnPath;
		}

		public MimeMessage getMimeMessage() {
			return mimeMessage;
		}

		public String getReturnPath() {
			return returnPath;
		}
	}

}