package com.ozacc.mail;

import java.io.File;

import org.apache.velocity.VelocityContext;

/**
 * VelocityϢȤưŪ˥᡼ǡΥǡMail󥹥󥹤륤󥿡ե
 * 
 * @see com.ozacc.mail.XMLMailBuilder
 * @see com.ozacc.mail.impl.JDomXMLMailBuilder
 * 
 * @author Tomohiro Otsuka
 * @version $Id: VelocityMailBuilder.java,v 1.1 2004/09/04 13:56:12 otsuka Exp $
 */
public interface VelocityMailBuilder extends MailBuilder {

	/**
	 * ꤵ줿饹ѥΥեɤ߹Mail󥹥󥹤ޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param classPath ᡼Ƥ򵭽ҤեΥѥ
	 * @param context VelocityContext
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	Mail buildMail(String classPath, VelocityContext context) throws MailBuildException;

	/**
	 * ꤵ줿եɤ߹Mail󥹥󥹤ޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param file ᡼Ƥ򵭽Ҥե
	 * @param context VelocityContext
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	Mail buildMail(File file, VelocityContext context) throws MailBuildException;

}