/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class Mail {
    public static final String JIS_CHARSET = "ISO-2022-JP";
    private String charset = "ISO-2022-JP";
    private String text;
    private InternetAddress from;
    private String subject;
    private List to;
    private List cc;
    private List bcc;
    private InternetAddress returnPath;
    private InternetAddress replyTo;
    private String importance;
    private Map xHeaders;

    public Mail() {
    }

    public Mail(String charset) {
        this();
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setImportance(String importance) throws IllegalArgumentException {
        if (!("high".equals(importance) || "normal".equals(importance) || "low".equals(importance))) {
            throw new IllegalArgumentException("'" + importance + "'\u306f\u3001\u30e1\u30fc\u30eb\u91cd\u8981\u5ea6\u306b\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044\u5024\u3067\u3059\u3002");
        }
        this.importance = importance;
    }

    public String getImportance() {
        return this.importance;
    }

    public void addTo(String email) throws IllegalArgumentException {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        try {
            this.to.add(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void addTo(String email, String name) throws IllegalArgumentException {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        try {
            this.to.add(new InternetAddress(email, name, this.charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress[] getTo() {
        if (this.to == null) {
            return new InternetAddress[0];
        }
        return this.to.toArray(new InternetAddress[this.to.size()]);
    }

    public void addCc(String email) throws IllegalArgumentException {
        if (this.cc == null) {
            this.cc = new ArrayList();
        }
        try {
            this.cc.add(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void addCc(String email, String name) throws IllegalArgumentException {
        if (this.cc == null) {
            this.cc = new ArrayList();
        }
        try {
            this.cc.add(new InternetAddress(email, name, this.charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress[] getCc() {
        if (this.cc == null) {
            return new InternetAddress[0];
        }
        return this.cc.toArray(new InternetAddress[this.cc.size()]);
    }

    public void addBcc(String email) throws IllegalArgumentException {
        if (this.bcc == null) {
            this.bcc = new ArrayList();
        }
        try {
            this.bcc.add(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress[] getBcc() {
        if (this.bcc == null) {
            return new InternetAddress[0];
        }
        return this.bcc.toArray(new InternetAddress[this.bcc.size()]);
    }

    public void setFrom(String email) throws IllegalArgumentException {
        try {
            this.from = new InternetAddress(email);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void setFrom(String email, String name) throws IllegalArgumentException {
        try {
            this.from = new InternetAddress(email, name, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public void setReturnPath(String email) throws IllegalArgumentException {
        try {
            this.returnPath = new InternetAddress(email);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress getReturnPath() {
        return this.returnPath;
    }

    public void setReplyTo(String email) throws IllegalArgumentException {
        try {
            this.replyTo = new InternetAddress(email);
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress getReplyTo() {
        return this.replyTo;
    }

    public String getSubject() {
        if (this.subject == null) {
            return "";
        }
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getText() {
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void addXHeader(String key, String value) {
        if (this.xHeaders == null) {
            this.xHeaders = new HashMap();
        }
        if (key.startsWith("X-")) {
            this.xHeaders.put(key, value);
        } else {
            this.xHeaders.put("X-" + key, value);
        }
    }

    public Map getXHeaders() {
        if (this.xHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.xHeaders);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Mail: ");
        sb.append("from=").append(this.from == null ? "null" : this.from.toUnicodeString()).append("; ");
        sb.append("replyTo=").append(this.replyTo == null ? "null" : this.replyTo.toUnicodeString()).append("; ");
        sb.append("to=").append(this.arrayToCommaDelimitedString(this.to)).append("; ");
        sb.append("cc=").append(this.arrayToCommaDelimitedString(this.cc)).append("; ");
        sb.append("bcc=").append(this.arrayToCommaDelimitedString(this.bcc)).append("; ");
        sb.append("subject=").append(this.subject).append("; ");
        sb.append("text=").append(this.text);
        return sb.toString();
    }

    private String arrayToCommaDelimitedString(List list) {
        if (list == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int num = list.size();
        while (i < num) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(((InternetAddress)list.get(i)).toUnicodeString());
            ++i;
        }
        return sb.toString();
    }

    public static class Importance {
        public static final String HIGH = "high";
        public static final String NORMAL = "normal";
        public static final String LOW = "low";
    }
}

