/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLMailBuilderImpl
implements MailBuilder {
    private DocumentBuilder db;

    public Mail buildMail(String classPath) throws MailBuildException {
        Document doc;
        try {
            doc = this.getDocumentFromClassPath(classPath);
        }
        catch (SAXException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        return this.build(doc);
    }

    protected synchronized Document getDocumentFromClassPath(String classPath) throws SAXException, IOException {
        Document document;
        block2: {
            InputStream is = this.getClass().getResourceAsStream(classPath);
            DocumentBuilder db = this.createDocumentBuilder();
            try {
                document = db.parse(is);
                Object var4_5 = null;
                if (is == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (is == null) break block3;
                    is.close();
                }
                throw throwable;
            }
            is.close();
        }
        return document;
    }

    public Mail buildMail(File file) throws MailBuildException {
        Document doc;
        try {
            doc = this.getDocumentFromFile(file);
        }
        catch (SAXException e) {
            throw new MailBuildException("XML\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MailBuildException("XML\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
        }
        return this.build(doc);
    }

    protected Mail build(Document doc) {
        Element root = doc.getDocumentElement();
        Mail mail = new Mail();
        this.setReturnPath(root, mail);
        this.setFrom(root, mail);
        this.setRecipients(root, mail);
        this.setReplyTo(root, mail);
        this.setSubject(root, mail);
        this.setText(root, mail);
        return mail;
    }

    private void setReplyTo(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("replyTo");
        Element replyTo = (Element)nodes.item(0);
        if (replyTo != null && replyTo.getAttribute("email").length() > 0) {
            mail.setReplyTo(replyTo.getAttribute("email"));
        }
    }

    private void setText(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("body");
        Element bodyElem = (Element)nodes.item(0);
        if (bodyElem == null) {
            return;
        }
        String body = bodyElem.getFirstChild().getNodeValue();
        mail.setText(body.trim());
    }

    private void setSubject(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("subject");
        Element subjectElem = (Element)nodes.item(0);
        if (subjectElem == null) {
            return;
        }
        String subject = subjectElem.getFirstChild().getNodeValue();
        mail.setSubject(subject.trim());
    }

    private void setRecipients(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("recipients");
        Element recipientsElem = (Element)nodes.item(0);
        if (recipientsElem == null) {
            return;
        }
        NodeList recipientElemList = recipientsElem.getChildNodes();
        int i = 0;
        int max = recipientElemList.getLength();
        while (i < max) {
            Node node = recipientElemList.item(i);
            if (node.getNodeType() == 1) {
                Element e = (Element)node;
                if ("to".equals(e.getNodeName())) {
                    if (e.getAttribute("email").length() > 0) {
                        if (e.getAttribute("name").length() > 0) {
                            mail.addTo(e.getAttribute("email"), e.getAttribute("name"));
                        } else {
                            mail.addTo(e.getAttribute("email"));
                        }
                    }
                } else if ("cc".equals(e.getNodeName())) {
                    if (e.getAttribute("email").length() > 0) {
                        if (e.getAttribute("name").length() > 0) {
                            mail.addCc(e.getAttribute("email"), e.getAttribute("name"));
                        } else {
                            mail.addCc(e.getAttribute("email"));
                        }
                    }
                } else if (e.getAttribute("email").length() > 0) {
                    mail.addBcc(e.getAttribute("email"));
                }
            }
            ++i;
        }
    }

    private void setReturnPath(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("returnPath");
        Element returnPath = (Element)nodes.item(0);
        if (returnPath != null && returnPath.getAttribute("email").length() > 0) {
            mail.setReturnPath(returnPath.getAttribute("email"));
        }
    }

    private void setFrom(Element root, Mail mail) {
        NodeList nodes = root.getElementsByTagName("from");
        Element from = (Element)nodes.item(0);
        if (from != null && from.getAttribute("email").length() > 0) {
            if (from.getAttribute("name").length() > 0) {
                mail.setFrom(from.getAttribute("email"), from.getAttribute("name"));
            } else {
                mail.setFrom(from.getAttribute("email"));
            }
        }
    }

    protected synchronized Document getDocumentFromFile(File file) throws SAXException, IOException {
        DocumentBuilder db = this.createDocumentBuilder();
        return db.parse(file);
    }

    protected DocumentBuilder createDocumentBuilder() throws FactoryConfigurationError {
        if (this.db == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setValidating(true);
            try {
                this.db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.db;
    }
}

