package com.ozacc.mail.impl;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

import com.ozacc.mail.Mail;

/**
 * MimeMessage󥹥󥹤륯饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: MimeMessageBuilder.java,v 1.5 2004/09/14 00:04:06 otsuka Exp $
 */
public class MimeMessageBuilder {

	private MimeMessage message;

	private String charset = Mail.JIS_CHARSET;

	private boolean hasRecipient = false;

	/**
	 * 󥹥ȥ饯
	 * ǥեȤʸ ISO-2022-JP 󥳡ǥ󥰤˻Ѥޤ
	 * 
	 * @param mimeMessage
	 */
	public MimeMessageBuilder(MimeMessage mimeMessage) {
		this.message = mimeMessage;
	}

	/**
	 * 󥹥ȥ饯
	 * ʸ̾Υ󥳡ǥ󥰤˻Ѥʸɤꤷޤ
	 * 
	 * @param mimeMessage
	 * @param charset 󥳡ǥ󥰤˻Ѥʸ
	 */
	public MimeMessageBuilder(MimeMessage mimeMessage, String charset) {
		this.message = mimeMessage;
		this.charset = charset;
	}

	/**
	 * 󥹥ȥ饯ΰϤ줿MimeMessage򤽤Τޤ֤ޤ
	 * 
	 * @return MimeMessage
	 */
	public MimeMessage getMimeMessage() {
		return this.message;
	}

	/**
	 * ꤵ줿᡼뤫MimeMessageޤ
	 * 
	 * @param mail MimeMessageΥȤʤMail
	 * @throws MessagingException
	 * @throws UnsupportedEncodingException
	 */
	public void buildMimeMessage(Mail mail) throws UnsupportedEncodingException, MessagingException {

		setFrom(mail);

		setSubject(mail);

		setText(mail);

		setTo(mail);

		setCc(mail);

		setBcc(mail);

		setReplyTo(mail);

		setXHeaders(mail);

		setImportance(mail);

		if (!hasRecipient) {
			throw new MessagingException("λ꤬ޤToCcBccΤ줫Ĥϻꤹɬפޤ");
		}

	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setXHeaders(Mail mail) throws MessagingException {
		Map headers = mail.getXHeaders();
		if (headers == null) {
			return;
		}

		Iterator itr = headers.keySet().iterator();
		while (itr.hasNext()) {
			String key = (String)itr.next();
			String value = (String)headers.get(key);
			message.setHeader(key, value);
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setImportance(Mail mail) throws MessagingException {
		if (mail.getImportance() != null) {
			message.setHeader("Importance", mail.getImportance());

			int level = 3;
			if (Mail.Importance.HIGH.equals(mail.getImportance())) {
				level = 1;
			} else if (Mail.Importance.LOW.equals(mail.getImportance())) {
				level = 5;
			}
			message.setHeader("X-Priority", String.valueOf(level));
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setReplyTo(Mail mail) throws MessagingException {
		if (mail.getReplyTo() != null) {
			message.setReplyTo(new InternetAddress[] { mail.getReplyTo() });
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setBcc(Mail mail) throws MessagingException {
		if (mail.getBcc().length > 0) {
			message.setRecipients(MimeMessage.RecipientType.BCC, mail.getBcc());
			hasRecipient = true;
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setCc(Mail mail) throws MessagingException {
		if (mail.getCc().length > 0) {
			message.setRecipients(MimeMessage.RecipientType.CC, mail.getCc());
			hasRecipient = true;
		}
	}

	/**
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setTo(Mail mail) throws MessagingException {
		if (mail.getTo().length > 0) {
			message.setRecipients(MimeMessage.RecipientType.TO, mail.getTo());
			hasRecipient = true;
		}
	}

	/**
	 * ʸ򥻥åȡ
	 * <p>
	 * NOTE: ʸκǸ˲ԤʤMozillaϤΥ᡼顼ǺǽԤܸ줬ʸƤޤ١
	 * message.setTextΰǺǸ\nɲäƤ롣
	 * 
	 * @param mail 
	 * @throws MessagingException
	 */
	private void setText(Mail mail) throws MessagingException {
		if (charset != null) {
			if (charset.equalsIgnoreCase(Mail.JIS_CHARSET)) {
				// Cp932饹ѤơŪJISѴ
				message.setText(Cp932.toJIS(mail.getText()) + "\n", charset);

				message.setHeader("Content-Transfer-Encoding", "7bit");
			} else {
				message.setText(mail.getText() + "\n", charset);
			}
		} else {
			message.setText(mail.getText());
		}
	}

	/**
	 * @param mail
	 * @throws MessagingException
	 * @throws UnsupportedEncodingException
	 */
	private void setSubject(Mail mail) throws UnsupportedEncodingException, MessagingException {
		if (charset != null) {
			if (charset.equalsIgnoreCase(Mail.JIS_CHARSET)) {
				String subject = Cp932.toJIS(mail.getSubject());
				message.setSubject(MimeUtility.encodeText(subject, charset, "B"));
			} else {
				message.setSubject(mail.getSubject(), charset);
			}
		} else {
			message.setSubject(mail.getSubject());
		}
	}

	/**
	 * @param mail
	 * @throws MessagingException 
	 */
	private void setFrom(Mail mail) throws MessagingException {
		message.setFrom(mail.getFrom());
	}

}