/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.mock;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MailException;
import com.ozacc.mail.SendMail;
import com.ozacc.mail.impl.MimeMessageBuilder;
import com.ozacc.mail.mock.AssertionFailedException;
import com.ozacc.mail.mock.MockMail;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MockSendMail
implements SendMail {
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HOST = "localhost";
    public static final String JIS_CHARSET = "ISO-2022-JP";
    private static final String RETURN_PATH_KEY = "mail.smtp.from";
    private String protocol = "smtp";
    private String host = "localhost";
    private int port = -1;
    private String username;
    private String password;
    private String charset = "ISO-2022-JP";
    private String returnPath;
    private List sentMails;
    private List mimeMessages;
    private List expectedMails;
    private boolean debug;

    public MockSendMail() {
        this.initialize();
    }

    public void initialize() {
        this.sentMails = new ArrayList();
        this.expectedMails = new ArrayList();
        this.mimeMessages = new ArrayList();
    }

    public MimeMessage[] getMimeMessages() {
        return this.mimeMessages.toArray(new MimeMessage[this.mimeMessages.size()]);
    }

    public Mail[] getSentMails() {
        return this.sentMails.toArray(new Mail[this.sentMails.size()]);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private void debug(String message) {
        if (this.debug) {
            System.out.println("[" + Thread.currentThread().getName() + "] DEBUG " + this.getClass().getName() + " - " + message);
        }
    }

    public void addExpectedMail(Mail expectedMail) {
        this.expectedMails.add(expectedMail);
    }

    public void addExpectedMail(Mail[] expectedMails) {
        int i = 0;
        while (i < expectedMails.length) {
            this.addExpectedMail(expectedMails[i]);
            ++i;
        }
    }

    public void verify() throws AssertionFailedException {
        this.debug("======================================================");
        this.debug("                      verify()                        ");
        this.debug("======================================================");
        int numOfExpectedMails = this.expectedMails.size();
        int numOfSentMails = this.sentMails.size();
        if (numOfExpectedMails != numOfSentMails) {
            throw new AssertionFailedException("\u671f\u5f85\u30e1\u30fc\u30eb\u6570<" + numOfExpectedMails + ">\u3068\u9001\u4fe1\u30e1\u30fc\u30eb\u6570<" + numOfSentMails + ">\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        this.debug("\u671f\u5f85\u30e1\u30fc\u30eb\u6570\u3068\u9001\u4fe1\u30e1\u30fc\u30eb\u6570\u306f\u4e00\u81f4\u3057\u307e\u3057\u305f\u3002[" + numOfExpectedMails + "\u901a]");
        int i = 0;
        while (i < numOfExpectedMails) {
            Mail expected = (Mail)this.expectedMails.get(i);
            Mail sent = (Mail)this.sentMails.get(i);
            this.debug(String.valueOf(i + 1) + "\u901a\u76ee\u306e\u30c1\u30a7\u30c3\u30af\u3092\u958b\u59cb\u3057\u307e\u3059\u3002(" + (expected instanceof MockMail ? "MockMail" : "Mail") + " - Mail)");
            this.checkEquality(expected, sent, i + 1);
            this.debug(String.valueOf(i + 1) + "\u901a\u76ee\u306e\u671f\u5f85\u30e1\u30fc\u30eb\u3068\u9001\u4fe1\u30e1\u30fc\u30eb\u5185\u5bb9\u306f\u4e00\u81f4\u3057\u307e\u3057\u305f\u3002");
            ++i;
        }
        this.debug("verify\u30d7\u30ed\u30bb\u30b9\u306f\u5168\u3066\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
        this.debug("======================================================");
    }

    public void checkEquality(Mail expected, Mail sent, int num) throws AssertionFailedException {
        int i;
        boolean mockMode = false;
        if (expected instanceof MockMail) {
            mockMode = true;
        }
        if (expected.isMultipartMail()) {
            if (!mockMode) {
                if (expected.getHtmlText() == null && sent.getHtmlText() != null || expected.getHtmlText() != null && sent.getHtmlText() == null || !expected.getHtmlText().equals(sent.getHtmlText())) {
                    this.throwExceptioWithMessage("HTML\u672c\u6587", expected.getHtmlText(), sent.getHtmlText(), num);
                }
            } else if (mockMode && expected.getHtmlText() != null && !expected.getHtmlText().equals(sent.getHtmlText())) {
                this.throwExceptioWithMessage("HTML\u672c\u6587", expected.getHtmlText(), sent.getHtmlText(), num);
            }
        }
        if (!mockMode || mockMode && expected.getReturnPath() != null) {
            if (expected.getReturnPath() != null && sent.getReturnPath() != null) {
                if (!expected.getReturnPath().equals((Object)sent.getReturnPath())) {
                    this.throwExceptioWithMessage("Return-Path\u30a2\u30c9\u30ec\u30b9", expected.getReturnPath().toUnicodeString(), sent.getReturnPath().toUnicodeString(), num);
                }
            } else if (expected.getReturnPath() != null && sent.getReturnPath() == null || expected.getReturnPath() == null && sent.getReturnPath() != null) {
                throw new AssertionFailedException();
            }
        }
        InternetAddress[] expectedAddresses = expected.getTo();
        InternetAddress[] sentAddresses = sent.getTo();
        if (!mockMode || mockMode && expectedAddresses.length > 0) {
            if (expectedAddresses.length != sentAddresses.length) {
                this.throwExceptioWithMessage("To\u30a2\u30c9\u30ec\u30b9\u6570", Integer.toString(expectedAddresses.length), Integer.toString(sentAddresses.length), num);
            }
            i = 0;
            while (i < expectedAddresses.length) {
                if (!expectedAddresses[i].equals((Object)sentAddresses[i])) {
                    this.throwExceptioWithMessage("To\u30a2\u30c9\u30ec\u30b9", expectedAddresses[i].toUnicodeString(), sentAddresses[i].toUnicodeString(), num);
                }
                ++i;
            }
        }
        expectedAddresses = expected.getCc();
        sentAddresses = sent.getCc();
        if (!mockMode || mockMode && expectedAddresses.length > 0) {
            if (expectedAddresses.length != sentAddresses.length) {
                this.throwExceptioWithMessage("Cc\u30a2\u30c9\u30ec\u30b9\u6570", Integer.toString(expectedAddresses.length), Integer.toString(sentAddresses.length), num);
            }
            i = 0;
            while (i < expectedAddresses.length) {
                if (!expectedAddresses[i].equals((Object)sentAddresses[i])) {
                    this.throwExceptioWithMessage("Cc\u30a2\u30c9\u30ec\u30b9", expectedAddresses[i].toUnicodeString(), sentAddresses[i].toUnicodeString(), num);
                }
                ++i;
            }
        }
        expectedAddresses = expected.getBcc();
        sentAddresses = sent.getBcc();
        if (!mockMode || mockMode && expectedAddresses.length > 0) {
            if (expectedAddresses.length != sentAddresses.length) {
                this.throwExceptioWithMessage("Bcc\u30a2\u30c9\u30ec\u30b9\u6570", Integer.toString(expectedAddresses.length), Integer.toString(sentAddresses.length), num);
            }
            i = 0;
            while (i < expectedAddresses.length) {
                if (!expectedAddresses[i].equals((Object)sentAddresses[i])) {
                    this.throwExceptioWithMessage("Bcc\u30a2\u30c9\u30ec\u30b9", expectedAddresses[i].toUnicodeString(), sentAddresses[i].toUnicodeString(), num);
                }
                ++i;
            }
        }
        if (!mockMode || mockMode && expected.getReplyTo() != null) {
            if (expected.getReplyTo() != null && sent.getReplyTo() != null) {
                if (!expected.getReplyTo().equals((Object)sent.getReplyTo())) {
                    this.throwExceptioWithMessage("ReplyTo\u30a2\u30c9\u30ec\u30b9", expected.getReplyTo().toUnicodeString(), sent.getReplyTo().toUnicodeString(), num);
                }
            } else if (expected.getReplyTo() != null && sent.getReplyTo() == null || expected.getReplyTo() == null && sent.getReplyTo() != null) {
                throw new AssertionFailedException();
            }
        }
        if ((!mockMode || mockMode && expected.getSubject().length() > 0) && !expected.getSubject().equals(sent.getSubject())) {
            this.throwExceptioWithMessage("\u4ef6\u540d", expected.getSubject(), sent.getSubject(), num);
        }
        if ((!mockMode || mockMode && expected.getText().length() > 0) && !expected.getText().equals(sent.getText())) {
            this.throwExceptioWithMessage("\u672c\u6587", expected.getText(), sent.getText(), num);
        }
    }

    private void throwExceptioWithMessage(String name, String expectedValue, String sentValue, int num) throws AssertionFailedException {
        String message = String.valueOf(num) + "\u756a\u76ee\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3067\u3001\u300c" + name + "\u300d\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u671f\u5f85\u5024='" + expectedValue + "', \u9001\u4fe1\u5024='" + sentValue + "'";
        this.debug(message);
        this.debug("verify\u30d7\u30ed\u30bb\u30b9\u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        this.debug("******************************************************");
        throw new AssertionFailedException(message);
    }

    public void send(Mail mail) throws MailException {
        this.send(new Mail[]{mail});
    }

    public void send(Mail[] mails) throws MailException {
        this.debug("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3059\u308b\u30d5\u30ea\u3002");
        this.debug("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u306b\u63a5\u7d9a\u3057\u305f\u30d5\u30ea\u3002");
        Session session = Session.getInstance((Properties)new Properties());
        int i = 0;
        while (i < mails.length) {
            Mail mail = mails[i];
            MimeMessage message = new MimeMessage(session);
            MimeMessageBuilder builder = new MimeMessageBuilder(message);
            try {
                builder.buildMimeMessage(mail);
            }
            catch (UnsupportedEncodingException e) {
                throw new MailBuildException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002", e);
            }
            catch (MessagingException e) {
                throw new MailBuildException("MimeMessage\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
            this.mimeMessages.add(message);
            this.debug("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3059\u308b\u30d5\u30ea\u3002");
            this.sentMails.add(mail);
            this.debug(mail.toString());
            this.debug("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u305f\u30d5\u30ea\u3002");
            ++i;
        }
        this.debug("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3059\u308b\u30d5\u30ea\u3002");
        this.debug("SMTP\u30b5\u30fc\u30d0[" + this.host + "]\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3057\u305f\u30d5\u30ea\u3002");
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        throw new UnsupportedOperationException("\u7533\u3057\u8a33\u3054\u3056\u3044\u307e\u305b\u3093\u3002MockSendMail\u3067\u306f\u3001\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
    }

    public void send(MimeMessage[] mimeMessages) throws MailException {
        throw new UnsupportedOperationException("\u7533\u3057\u8a33\u3054\u3056\u3044\u307e\u305b\u3093\u3002MockSendMail\u3067\u306f\u3001\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

