package com.ozacc.mail.impl;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * ozacc-mail libraryDTDե򥯥饹ѥ夫鸡ФEntityResolver
 * 
 * @since 1.1
 * 
 * @author Tomohiro Otsuka
 * @version $Id: DTDEntityResolver.java,v 1.2 2004/10/05 13:21:18 otsuka Exp $
 */
class DTDEntityResolver implements EntityResolver {

	private static Log log = LogFactory.getLog(DTDEntityResolver.class);

	private static final String URL = "http://www.ozacc.com/library/dtd/";

	/**
	 * 饹ѥcom/ozacc/mail׾ǡꤵ줿systemIdΥե̾Ʊե򸡽Фޤ
	 * ⤷⸡ФǤʤnull֤ޤ(ɬФǤϤǤ)
	 * 
	 * @see org.xml.sax.EntityResolver#resolveEntity(java.lang.String, java.lang.String)
	 */
	public InputSource resolveEntity(String publicId, String systemId) throws SAXException,
																		IOException {
		if (systemId != null && systemId.startsWith(URL)) {
			log.debug("饹ѥ[com/ozacc/mail/]'" + systemId + "'μߤޤ");

			// Search for DTD
			ClassLoader classLoader = this.getClass().getClassLoader();
			InputStream dtdStream = classLoader.getResourceAsStream("com/ozacc/mail/"
					+ systemId.substring(URL.length()));

			if (dtdStream == null) {
				log.debug("'" + systemId + "'ϥ饹ѥ˸ĤޤǤ");
				return null;
			} else {
				log.debug("'" + systemId + "'򥯥饹ѥǼޤ");
				InputSource source = new InputSource(dtdStream);
				source.setPublicId(publicId);
				source.setSystemId(systemId);
				return source;
			}
		} else {
			// use the default behaviour
			return null;
		}
	}

}