/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.impl;

import java.util.Random;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

class OMLMimeMessage
extends MimeMessage {
    private String messageId;
    private static Random random = new Random();

    OMLMimeMessage(Session session, String messageId) {
        super(session);
        String[] parts = messageId.split("@");
        if (parts.length == 1) {
            this.messageId = "@" + messageId;
        } else if (parts.length == 2) {
            this.messageId = parts[0].length() > 0 && !parts[0].startsWith(".") ? "." + messageId : messageId;
        }
    }

    protected void updateHeaders() throws MessagingException {
        super.updateHeaders();
        this.setHeader("Message-ID", this.generateRandomMessageId());
    }

    protected String generateRandomMessageId() {
        StringBuffer buf = new StringBuffer();
        buf.append(System.currentTimeMillis()).append(".");
        int i = 0;
        while (i < 16) {
            long num = Math.abs(random.nextInt(10));
            buf.append(num);
            ++i;
        }
        buf.append(this.messageId);
        return buf.toString();
    }
}

