/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.rss.impl;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.ParseException;
import com.ozacc.blog.rss.ParseTimeoutException;
import com.ozacc.blog.rss.RSSAutoDiscovery;
import com.ozacc.blog.rss.RSSParser;
import com.ozacc.blog.rss.impl.RSSAutoDiscoveryImpl;
import com.ozacc.blog.rss.support.XmlInputStreamParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RSSParserImpl
implements RSSParser {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    private static Log log;
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    private RSSAutoDiscovery rssAutoDiscovery;
    private XmlInputStreamParser xmlInputStreamParser;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.rss.impl.RSSParserImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public RSSParserImpl() {
        this.initRSSAutoDiscovery();
    }

    public RSSParserImpl(XmlInputStreamParser xmlInputStreamParser) {
        this();
        this.setXmlInputStreamParser(xmlInputStreamParser);
    }

    private void initRSSAutoDiscovery() {
        this.rssAutoDiscovery = new RSSAutoDiscoveryImpl();
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public void setXmlInputStreamParser(XmlInputStreamParser xmlInputStreamParser) {
        this.xmlInputStreamParser = xmlInputStreamParser;
    }

    public Channel parseRSS(URL rssUrl) throws ParseException {
        return this.parseRSS(rssUrl.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Channel parseRSS(String url) throws ParseException {
        Channel channel;
        if (this.xmlInputStreamParser == null) {
            throw new IllegalStateException("XMLInputStreamParser\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        HttpClient client = new HttpClient();
        log.debug((Object)("\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.connectionTimeout + "]"));
        client.setConnectionTimeout(this.connectionTimeout);
        log.debug((Object)("\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.readTimeout + "]"));
        client.setTimeout(this.readTimeout);
        GetMethod method = new GetMethod(url);
        try {
            try {
                log.debug((Object)("HTTP\u63a5\u7d9a\u3092\u884c\u3044\u307e\u3059\u3002[" + url + "]"));
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    throw new ParseException("HTTP\u63a5\u7d9a\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[HTTP_STATUS='" + HttpStatus.getStatusText((int)statusCode) + "', rssUrl='" + url + "']");
                }
                InputStream is = method.getResponseBodyAsStream();
                channel = this.parseXmlInputStream(is);
                Object var6_11 = null;
            }
            catch (HttpConnection.ConnectionTimeoutException e) {
                throw new ParseTimeoutException("HTTP\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002[rssUrl='" + url + "']", e);
            }
            catch (HttpRecoverableException e) {
                throw new ParseTimeoutException("HTTP\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002[rssUrl='" + url + "']", e);
            }
            catch (ParseException e) {
                throw new ParseException("RSS\u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[rssUrl='" + url + "']", e);
            }
            catch (IOException e) {
                throw new ParseException("\u6307\u5b9a\u3055\u308c\u305fURL\u304b\u3089\u306eRSS\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[rssUrl='" + url + "']", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            method.releaseConnection();
            throw throwable;
        }
        method.releaseConnection();
        return channel;
    }

    private Channel parseXmlInputStream(InputStream is) throws ParseException {
        log.debug((Object)"RSS\u3092\u30d1\u30fc\u30b9\u3057\u307e\u3059\u3002");
        return this.xmlInputStreamParser.parseXmlInputStream(is);
    }

    public Channel discoverAndParseRSS(URL targetPageUrl) throws ParseException {
        URL[] rssUrls;
        try {
            rssUrls = this.rssAutoDiscovery.discoverRSSUrls(targetPageUrl);
        }
        catch (ParseException e) {
            throw new ParseException("RSS\u306eAutoDiscovery\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[url='" + targetPageUrl + "']", e);
        }
        if (rssUrls.length > 0) {
            return this.parseRSS(rssUrls[0]);
        }
        throw new ParseException("\u6307\u5b9a\u3055\u308c\u305fURL\u306e\u30da\u30fc\u30b8\u3067\u306fRSS\u306eURL\u3092\u898b\u3064\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002[url='" + targetPageUrl + "']");
    }

    public Channel discoverAndParseRSS(String targetPageUrl) throws ParseException {
        try {
            return this.discoverAndParseRSS(new URL(targetPageUrl));
        }
        catch (MalformedURLException e) {
            throw new ParseException("\u6307\u5b9a\u3055\u308c\u305fURL\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002[url='" + targetPageUrl + "']", e);
        }
    }
}

