/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.rss.informa;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.RSSGenerator;
import com.ozacc.blog.rss.RSSVersion;
import com.ozacc.blog.rss.informa.ChannelAdapter;
import com.ozacc.blog.rss.informa.RSS_1_0_Exporter;
import com.ozacc.blog.rss.informa.RSS_2_0_Exporter;
import de.nava.informa.core.ChannelExporterIF;
import de.nava.informa.core.ChannelIF;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;

public class RSSGeneratorImpl
implements RSSGenerator {
    public static final String DEFAULT_CHARSET = "utf-8";
    private String charset = "utf-8";
    protected ChannelExporterIF exporter;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public RSSGeneratorImpl() {
    }

    public RSSGeneratorImpl(String charset) {
        this();
        this.charset = charset;
    }

    public Channel newChannel() {
        return new ChannelAdapter((ChannelIF)new de.nava.informa.impl.basic.Channel());
    }

    public void write(Channel channel, File file, RSSVersion rssVersion) throws IOException {
        if (rssVersion == RSSVersion.RSS_1_0) {
            this.exporter = new RSS_1_0_Exporter(file, this.charset);
        } else if (rssVersion == RSSVersion.RSS_2_0) {
            this.exporter = new RSS_2_0_Exporter(file, this.charset);
        }
        ChannelIF c = ((ChannelAdapter)channel).getChannelIF();
        this.exporter.write(c);
    }

    public Document convertIntoJDOMDocument(Channel channel, RSSVersion rssVersion) {
        ChannelIF c = ((ChannelAdapter)channel).getChannelIF();
        if (rssVersion == RSSVersion.RSS_1_0) {
            return RSS_1_0_Exporter.getJdomDocument(c);
        }
        if (rssVersion == RSSVersion.RSS_2_0) {
            return RSS_2_0_Exporter.getJdomDocument(c);
        }
        throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fRSSVersion\u306f\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002[" + rssVersion + "]");
    }
}

