/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.blog.trackback.impl;

import com.ozacc.blog.trackback.ConnectionException;
import com.ozacc.blog.trackback.ConnectionTimeoutException;
import com.ozacc.blog.trackback.TrackBackAutoDiscovery;
import com.ozacc.blog.trackback.TrackBackException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrackBackAutoDiscoveryImpl
implements TrackBackAutoDiscovery {
    private static Log log;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    private int connectionTimeout = 5000;
    private int readTimeout = 5000;
    private Pattern rdfPattern = Pattern.compile("<rdf:RDF(.*?)</rdf:RDF>", 34);
    private Pattern trackBackPingPattern = Pattern.compile("trackback:ping=\"(.+?)\"", 32);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.blog.trackback.impl.TrackBackAutoDiscoveryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public URL[] discoverTrackBackUrls(URL url) throws TrackBackException {
        return this.discoverTrackBackUrls(url.toString());
    }

    private String getPageContent(URL targetPageUrl) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)targetPageUrl.openConnection();
        conn.connect();
        InputStream is = conn.getInputStream();
        InputStreamReader reader = new InputStreamReader(is);
        StringBuffer buf = new StringBuffer();
        char[] cbuf = new char[8192];
        while (reader.read(cbuf) != -1) {
            buf.append(cbuf);
        }
        String content = buf.toString();
        reader.close();
        conn.disconnect();
        return content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPageContent(String url) throws TrackBackException {
        String string;
        HttpClient client = new HttpClient();
        log.debug((Object)("\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.connectionTimeout + "]"));
        client.setConnectionTimeout(this.connectionTimeout);
        log.debug((Object)("\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002[" + this.readTimeout + "]"));
        client.setTimeout(this.readTimeout);
        GetMethod method = new GetMethod(url);
        try {
            try {
                log.debug((Object)("HTTP\u63a5\u7d9a\u3092\u884c\u3044\u307e\u3059\u3002[" + url + "]"));
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    throw new ConnectionException("\u6307\u5b9a\u3055\u308c\u305fURL\u3078\u306eHTTP\u63a5\u7d9a\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[HTTP_STATUS='" + HttpStatus.getStatusText((int)statusCode) + "', url='" + url + "']");
                }
                string = method.getResponseBodyAsString();
                Object var5_9 = null;
            }
            catch (HttpConnection.ConnectionTimeoutException e) {
                throw new ConnectionTimeoutException("HTTP\u63a5\u7d9a\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002[url='" + url + "']", e);
            }
            catch (HttpRecoverableException e) {
                throw new ConnectionTimeoutException("HTTP\u8aad\u8fbc\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3002[url='" + url + "']", e);
            }
            catch (IOException e) {
                throw new ConnectionException("\u6307\u5b9a\u3055\u308c\u305fURL\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u3002[url='" + url + "']", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            method.releaseConnection();
            throw throwable;
        }
        method.releaseConnection();
        return string;
    }

    public URL[] discoverTrackBackUrls(String url) throws TrackBackException {
        String content = this.getPageContent(url);
        ArrayList<URL> result = new ArrayList<URL>();
        Matcher rdfMatcher = this.rdfPattern.matcher(content);
        while (rdfMatcher.find()) {
            Matcher tbMatcher = this.trackBackPingPattern.matcher(rdfMatcher.group(1));
            if (!tbMatcher.find()) continue;
            try {
                result.add(new URL(tbMatcher.group(1)));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }
}

