package com.ozacc.blog.rss.support.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.Item;
import com.ozacc.blog.rss.ParseException;
import com.ozacc.blog.rss.impl.ChannelAdapter;
import com.ozacc.blog.rss.support.XmlInputStreamParser;
import com.ozacc.blog.util.DateFormat;

/**
 * ̤ʥꡣäCVSߥåȤƤޤޤ
 * 
 * @see com.ozacc.blog.rss.informa.XmlInputStreamParserImpl
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: DOMXmlInputStreamParserImpl.java,v 1.1.2.2 2004/12/05 05:38:05 otsuka Exp $
 */
public class DOMXmlInputStreamParserImpl implements XmlInputStreamParser {

	private static Log log = LogFactory.getLog(DOMXmlInputStreamParserImpl.class);

	/**
	 * @see com.ozacc.blog.rss.support.XmlInputStreamParser#parseXmlInputStream(java.io.InputStream)
	 */
	public Channel parseXmlInputStream(InputStream is) throws ParseException {
		Document doc;
		try {
			doc = getDocument(is);
			return parseXml(doc);
		} catch (Exception e) {
			throw new ParseException("RSS XMLΥѡ˼Ԥޤ", e);
		}
	}

	/**
	 * @param doc
	 * @return 
	 */
	private Channel parseXml(Document doc) {
		Node root = doc.getFirstChild();

		// Channelμ󥹥󥹤
		ChannelAdapter c = new ChannelAdapter();

		Node channel = doc.getElementsByTagName("channel").item(0);
		parseChannel(c, channel);

		NodeList items = doc.getElementsByTagName("item");
		parseItems(c, items);

		return c;
	}

	/**
	 * @param c
	 * @param items 
	 */
	private void parseItems(ChannelAdapter c, NodeList items) {
		for (int i = 0; i < items.getLength(); i++) {
			Node itemNode = items.item(i);
			log.debug(itemNode.getNodeName());
			Item item = c.newItem();
			if (isNodeName(itemNode, "title")) {
				item.setTitle(retrieveNodeValue(itemNode));
				continue;
			}
			if (isNodeName(itemNode, "link")) {
				try {
					item.setLink(new URL(retrieveNodeValue(itemNode)));
				} catch (MalformedURLException ignore) {}
				continue;
			}
			if (isNodeName(itemNode, "dc:description")) {
				item.setDescription(retrieveNodeValue(itemNode));
				continue;
			}
			if (isNodeName(itemNode, "dc:date")) {
				String d = retrieveNodeValue(itemNode);
				try {
					item.setDate(DateFormat.parse(d));
				} catch (java.text.ParseException e) {
					e.printStackTrace();
				}
				continue;
			}
			if (isNodeName(itemNode, "dc:creator")) {
				item.setCreator(retrieveNodeValue(itemNode));
				continue;
			}
			if (isNodeName(itemNode, "dc:subject")) {
				item.setSubject(retrieveNodeValue(itemNode));
				continue;
			}
			c.addItem(item);
		}
	}

	/**
	 * @param c
	 * @param channel 
	 */
	private void parseChannel(ChannelAdapter c, Node channel) {
		NodeList channelChildren = channel.getChildNodes();
		for (int i = 0; i < channelChildren.getLength(); i++) {
			Node channelChildNode = channelChildren.item(i);
			log.debug(channelChildNode.getNodeName());

			if (isNodeName(channelChildNode, "title")) {
				c.setTitle(retrieveNodeValue(channelChildNode));
				continue;
			}
			if (isNodeName(channelChildNode, "link")) {
				try {
					c.setLink(new URL(retrieveNodeValue(channelChildNode)));
				} catch (MalformedURLException ignore) {}
				continue;
			}
			if (isNodeName(channelChildNode, "description")) {
				c.setDescription(retrieveNodeValue(channelChildNode));
				continue;
			}
			if (isNodeName(channelChildNode, "dc:date")) {
				String d = retrieveNodeValue(channelChildNode);
				try {
					c.setDate(DateFormat.parse(d));
				} catch (java.text.ParseException e) {
					e.printStackTrace();
				}
				continue;
			}
			if (isNodeName(channelChildNode, "dc:creator")) {
				c.setCreator(retrieveNodeValue(channelChildNode));
				continue;
			}
			if (isNodeName(channelChildNode, "dc:language")) {
				c.setLanguage(retrieveNodeValue(channelChildNode));
				continue;
			}
		}
	}

	/**
	 * @param channelChildNode
	 * @return 
	 */
	private boolean isNodeName(Node channelChildNode, String name) {
		return name.equals(channelChildNode.getNodeName());
	}

	/**
	 * @param n
	 * @return 
	 */
	private String retrieveNodeValue(Node n) {
		Node valueNode = n.getFirstChild();
		if (valueNode != null) {
			return valueNode.getNodeValue();
		}
		return null;
	}

	/**
	 * @param is
	 * @throws FactoryConfigurationError
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 * @throws IOException 
	 */
	private Document getDocument(InputStream is) throws FactoryConfigurationError,
												ParserConfigurationException, SAXException,
												IOException {
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		dbf.setIgnoringComments(true);
		dbf.setIgnoringElementContentWhitespace(true);
		DocumentBuilder db = dbf.newDocumentBuilder();
		return db.parse(is);
	}

}