package com.ozacc.blog.trackback;

import java.io.Serializable;

/**
 * ȥåХåPing
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackPing.java,v 1.2.2.2 2004/12/08 07:13:56 otsuka Exp $
 */
public class TrackBackPing implements Serializable, Cloneable {

	private String title;

	private String excerpt;

	private String url;

	private String blogName;

	private String charset;

	/**
	 * 󥹥ȥ饯
	 */
	public TrackBackPing() {
		super();
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param title
	 * @param excerpt
	 * @param url
	 * @param blogName
	 */
	public TrackBackPing(String title, String excerpt, String url, String blogName) {
		this.title = title;
		this.excerpt = excerpt;
		this.url = url;
		this.blogName = blogName;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("[TrackBackPing ");
		buf.append("title='" + title + "', ");
		buf.append("excerpt='" + excerpt + "', ");
		buf.append("url='" + url + "', ");
		buf.append("blogName='" + blogName + "'");
		if (charset != null) {
			buf.append(", charset='" + charset + "'");
		}
		buf.append("]");
		return buf.toString();
	}

	/**
	 * @return ʸ
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * @param charset ʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * @return Returns ֥̾
	 */
	public String getBlogName() {
		return blogName;
	}

	/**
	 * @param blogName ֥̾
	 */
	public void setBlogName(String blogName) {
		this.blogName = blogName;
	}

	/**
	 * @return ֥ʸȴ衢
	 */
	public String getExcerpt() {
		return excerpt;
	}

	/**
	 * @param excerpt ֥ʸȴ衢
	 */
	public void setExcerpt(String excerpt) {
		this.excerpt = excerpt;
	}

	/**
	 * @return ֥Υȥ
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param title ֥Υȥ
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @return ֥URL
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * @param url ֥URL
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() {
		TrackBackPing ping = new TrackBackPing(title, excerpt, url, blogName);
		ping.setCharset(charset);
		return ping;
	}
}