package com.ozacc.blog.trackback.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.HttpConnection.ConnectionTimeoutException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ozacc.blog.trackback.ConnectionException;
import com.ozacc.blog.trackback.TrackBackAutoDiscovery;
import com.ozacc.blog.trackback.TrackBackException;
import com.ozacc.blog.util.CommonsHttpClientUtils;

/**
 * TrackBackAutoDiscovery󥿡եμ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackAutoDiscoveryImpl.java,v 1.1.2.4 2004/12/09 14:28:22 otsuka Exp $
 */
public class TrackBackAutoDiscoveryImpl implements TrackBackAutoDiscovery {

	private static Log log = LogFactory.getLog(TrackBackAutoDiscoveryImpl.class);

	public static final int DEFAULT_CONNECTION_TIMEOUT = 5000;

	public static final int DEFAULT_READ_TIMEOUT = 5000;

	private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;

	private int readTimeout = DEFAULT_READ_TIMEOUT;

	private boolean followRedirect = true;

	private Pattern rdfPattern = Pattern.compile("<rdf:RDF(.*?)</rdf:RDF>", Pattern.DOTALL
			| Pattern.CASE_INSENSITIVE);

	private Pattern trackBackPingPattern = Pattern.compile("trackback:ping=\"(.+?)\"",
			Pattern.DOTALL);

	/**
	 * @see com.ozacc.blog.trackback.TrackBackAutoDiscovery#discoverTrackBackUrls(java.net.URL)
	 */
	public URL[] discoverTrackBackUrls(URL url) throws TrackBackException {
		return discoverTrackBackUrls(url.toString());
	}

	/**
	 * @param targetPageUrl
	 * @return
	 * @throws IOException 
	 */
	private String getPageContent(URL targetPageUrl) throws IOException {
		HttpURLConnection conn = (HttpURLConnection)targetPageUrl.openConnection();
		conn.connect();
		InputStream is = conn.getInputStream();
		InputStreamReader reader = new InputStreamReader(is);

		StringBuffer buf = new StringBuffer();
		char[] cbuf = new char[8192];
		while (reader.read(cbuf) != -1) {
			buf.append(cbuf);
		}
		String content = buf.toString();

		reader.close();
		conn.disconnect();
		return content;
	}

	/**
	 * ꤵ줿URLGETꥯȤꡢΥ쥹ݥ󥹤ʸ֤ޤ
	 * 
	 * @param url URL
	 * @return URLΥ쥹ݥ
	 * @throws TrackBackException
	 */
	private String getPageContent(String url) throws TrackBackException {
		HttpClient client = new HttpClient();
		log.debug("³ॢȤꤷޤ[" + connectionTimeout + "]");
		client.setConnectionTimeout(connectionTimeout);
		log.debug("ɹॢȤꤷޤ[" + readTimeout + "]");
		client.setTimeout(readTimeout);

		HttpMethod method = new GetMethod(url);
		method.setFollowRedirects(followRedirect);
		try {
			log.debug("HTTP³Ԥޤ[" + url + "]");
			int statusCode = client.executeMethod(method);
			if (!CommonsHttpClientUtils.isSuccessfulResponse(statusCode, followRedirect)) {
				throw new ConnectionException("ꤵ줿URLؤHTTP³ǤޤǤ[HTTP_STATUS='"
						+ HttpStatus.getStatusText(statusCode) + "', url='" + url + "']");
			}
			return method.getResponseBodyAsString();
		} catch (ConnectionTimeoutException e) {
			throw new com.ozacc.blog.trackback.ConnectionTimeoutException("HTTP³ॢȡ[url='"
					+ url + "']", e);
		} catch (HttpRecoverableException e) {
			throw new com.ozacc.blog.trackback.ConnectionTimeoutException("HTTPɹॢȡ[url='"
					+ url + "']", e);
		} catch (IOException e) {
			throw new ConnectionException("ꤵ줿URLؤ³˼Ԥޤ[url='" + url + "']", e);
		} finally {
			method.releaseConnection();
		}
	}

	

	/**
	 * @see com.ozacc.blog.trackback.TrackBackAutoDiscovery#discoverTrackBackUrls(java.lang.String)
	 */
	public URL[] discoverTrackBackUrls(String url) throws TrackBackException {
		String content = getPageContent(url);

		List result = new ArrayList();
		Matcher rdfMatcher = rdfPattern.matcher(content);
		while (rdfMatcher.find()) {
			Matcher tbMatcher = trackBackPingPattern.matcher(rdfMatcher.group(1));
			if (tbMatcher.find()) {
				try {
					result.add(new URL(tbMatcher.group(1)));
				} catch (MalformedURLException e) {
					// ignore
				}
			}
		}
		return (URL[])result.toArray(new URL[result.size()]);
	}

	/**
	 * ³ॢȻ֤򥻥åȤޤñ̤ϥߥá
	 * ǥեȤ5,000ߥ(5)Ǥ
	 * 
	 * @param connectionTimeout ³ॢ (ms)
	 */
	public void setConnectionTimeout(int connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * ³ɹॢȻ֤򥻥åȤޤñ̤ϥߥá
	 * ǥեȤ5,000ߥ(5)Ǥ
	 * 
	 * @param timeout ɹॢ (ms)
	 */
	public void setReadTimeout(int timeout) {
		this.readTimeout = timeout;
	}

	/**
	 * URL쥯ȥ쥹ݥ(HTTP Status Code 3xx)֤Ƥˡ
	 * 쥯˥뤫ɤꤷޤǥեȤǤϡ쥯˥ޤ
	 * 
	 * @since 1.2.4
	 * @param followRedirect 쥯˥ trueǥեȤtrue
	 */
	public void setFollowRedirect(boolean followRedirect) {
		this.followRedirect = followRedirect;
	}

}