package com.ozacc.blog.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * ISO-8601˽सɽեޥå
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: DateFormat.java,v 1.3.2.2 2004/12/05 05:35:38 otsuka Exp $
 */
public class DateFormat {

	/**
	 * ISO-8601˽सɽ֤ޤ
	 * ( 1997-07-16T19:20:30+01:00)
	 * 
	 * @param date
	 * @return ɽ
	 */
	public static String format(Date date) {
		SimpleDateFormat formatter = getSimpleDateFormat();
		String result = formatter.format(date);
		String a = result.substring(0, result.length() - 2);
		String b = result.substring(result.length() - 2);
		return a + ":" + b;
	}

	/**
	 * ISO-8601˽सɽʸ󤫤Date󥹥󥹤ޤ
	 * 
	 * @param date ISO-8601˽सɽ
	 * @return Date󥹥
	 * @throws ParseException
	 */
	public static Date parse(String date) throws ParseException {
		SimpleDateFormat formatter = getSimpleDateFormat();
		String d = date.substring(0, date.lastIndexOf(':'))
				+ date.substring(date.lastIndexOf(':') + 1);
		return formatter.parse(d);
	}

	/**
	 * @return ISO-8601ѥSimpleDateFormat
	 */
	private static SimpleDateFormat getSimpleDateFormat() {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
		return formatter;
	}
}