package com.ozacc.blog.rss.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import junit.framework.TestCase;

import org.jdom.Document;
import org.jdom.output.XMLOutputter;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.Item;
import com.ozacc.blog.rss.RSSVersion;
import com.ozacc.blog.rss.informa.RSSGeneratorImpl;

/**
 * RSSGeneratorImplΥƥȥ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: RSSGeneratorImplTest.java,v 1.3.2.1 2004/12/09 14:27:44 otsuka Exp $
 */
public class RSSGeneratorImplTest extends TestCase {

	private RSSGeneratorImpl generator;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		generator = new RSSGeneratorImpl();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public final void testWriteRSS1_0() throws Exception {
		File dest = new File("target/test/data/index.rdf");
		dest.getParentFile().mkdirs();
		Channel c = getChannelForTest();
		generator.write(c, dest, RSSVersion.RSS_1_0);
	}

	public final void testWriteRSS2_0() throws Exception {
		File dest = new File("target/test/data/index.xml");
		dest.getParentFile().mkdirs();
		Channel c = getChannelForTest();
		generator.write(c, dest, RSSVersion.RSS_2_0);
	}

	public final void testConvertIntoJDOMDocument() throws Exception {
		try {
			Channel c = getChannelForTest();
			Document doc = generator.convertIntoJDOMDocument(c, RSSVersion.RSS_1_0);
			XMLOutputter out = new XMLOutputter();
			String rss = out.outputString(doc);
			System.out.println(rss);
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

	/**
	 * @throws MalformedURLException 
	 */
	private Channel getChannelForTest() throws MalformedURLException {
		Channel c = generator.newChannel();
		c.setTitle("ozacc-blog library");
		c.setLink(new URL("http://sourceforge.jp/projects/spring-ext/"));
		c.setDescription("Spring Frameworkᥤˡ¾IoCƥʤǤȤȤʤäꤹ⥸塼󶡤ꤷʤäꡣ");
		c.setLanguage("ja");

		Calendar cal = new GregorianCalendar(2004, 10, 24);
		c.setDate(cal.getTime());

		Item i1 = c.newItem();
		i1.setTitle("ozacc-mail library 1.1.3 ꡼");
		i1.setLink(new URL("http://sourceforge.jp/forum/forum.php?forum_id=5795"));
		i1.setDate(new Date());
		i1.setDescription(" MockSendMailΥХޤ");
		i1.setSubject("news");
		i1.setCreator("otsuka");
		c.addItem(i1);

		Item i2 = c.newItem();
		i2.setTitle("ozacc-mail library 1.1 ꡼");
		i2.setLink(new URL("http://sourceforge.jp/forum/forum.php?forum_id=5560"));
		i2.setDate(new Date());
		i2.setDescription(" ޥѡȥå(եźդHTML᡼)򥵥ݡȤꡢ¾Ȳɤޤ");
		i2.setSubject("news");
		i2.setCreator("otsuka");
		c.addItem(i2);

		return c;
	}

}