package com.ozacc.blog.rss.impl;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;

import com.ozacc.blog.rss.Channel;
import com.ozacc.blog.rss.informa.XmlInputStreamParserImpl;

/**
 * RSSParserImplΥƥȥ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: RSSParserImplTest.java,v 1.2.2.2 2004/12/09 07:29:45 otsuka Exp $
 */
public class RSSParserImplTest extends TestCase {

	private RSSParserImpl parser;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		BasicConfigurator.configure();

		parser = new RSSParserImpl();
		parser.setXmlInputStreamParser(new XmlInputStreamParserImpl());
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
		BasicConfigurator.resetConfiguration();
	}

	/*
	 * Channel parseRSS ΥƥΥ饹(String)
	 */
	public final void testParseRSSString() throws Exception {
		String rssUrl = "http://spring-ext.sourceforge.jp/blog/index.rdf";
		Channel channel = parser.parseRSS(rssUrl);

		/*RSSGenerator gen = new RSSGeneratorImpl();
		 File f = new File("target/test/data/index.rdf");
		 f.getParentFile().mkdirs();
		 gen.write(channel, f, RSSVersion.RSS_1_0);*/

		assertNotNull(channel);
		assertEquals("Spring Extensions", channel.getTitle());
		assertEquals("http://spring-ext.sourceforge.jp/blog/", channel.getLink().toString());
	}

}