package com.ozacc.blog.ping.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

import com.ozacc.blog.ping.ConnectionException;
import com.ozacc.blog.ping.FailedUpdatePingException;
import com.ozacc.blog.ping.UpdatePing;
import com.ozacc.blog.ping.UpdatePingClient;
import com.ozacc.blog.ping.UpdatePingException;
import com.ozacc.blog.ping.UpdatePingResponseException;

/**
 * XML-RPCѤƹPingUpdatePingClient󥿡եμ饹
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: XmlRpcUpdatePingClient.java,v 1.3.2.3 2004/12/05 05:35:38 otsuka Exp $
 */
class XmlRpcUpdatePingClient implements UpdatePingClient {

	private static Log log = LogFactory.getLog(XmlRpcUpdatePingClient.class);

	/** ǥեȤʸɡUTF-8ס */
	public static final String DEFAULT_CHARSET = "utf-8";

	/**  PingRPC᥽å̾<code>weblogUpdates.ping</code> */
	public static String PING_METHOD_NAME = "weblogUpdates.ping";

	private boolean debug = false;

	private String charset = DEFAULT_CHARSET;

	/**
	 * 󥹥ȥ饯
	 */
	public XmlRpcUpdatePingClient() {}

	/**
	 * ǥХåͭˤʤäƤ뤫ɤ֤ޤ
	 * 
	 * @return ǥХåͭˤʤäƤ true
	 */
	public boolean isDebug() {
		return debug;
	}

	/**
	 * XmlRpcClientΥǥХåͭˤޤ<br>
	 * ǥեȤǤ̵(false)Ǥ
	 * 
	 * @param debug ǥХåͭˤȤ true
	 */
	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	/**
	 * @return Returns the encoding.
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * PingǡΥ󥳡ɤ˻Ѥʸɤ򥻥åȤޤ
	 * ǥեȤUTF-8
	 * 
	 * @param charset PingǡΥ󥳡ɤ˻Ѥʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * XmlRpcClient#execute() ֤̤HashtableꤷƤޤ
	 * ʳξ硢㳰򥹥ޤ
	 * 
	 * @see com.ozacc.blog.ping.UpdatePingClient#ping(java.lang.String, java.lang.String, java.lang.String)
	 */
	public String ping(String pingUrl, String blogName, String blogUrl) throws UpdatePingException {
		UpdatePing ping = new UpdatePing(blogName, blogUrl);
		return ping(pingUrl, ping);
	}

	/**
	 * @see com.ozacc.blog.ping.UpdatePingClient#ping(java.lang.String, com.ozacc.blog.ping.Ping)
	 */
	public String ping(String pingUrl, UpdatePing ping) throws UpdatePingException {
		XmlRpcClient client = getRpcClient(pingUrl);
		Object result = execute(client, ping.getParameters());
		return processResult(result);
	}

	/**
	 * ꤵ줿RPC¹Է̥֥Ȥ쥹ݥ󥹥åޤ
	 * 
	 * @param result RPC¹Է̥֥
	 * @return ̥å
	 * @throws UpdatePingResponseException
	 * @throws FailedUpdatePingException
	 */
	protected String processResult(Object result) throws UpdatePingResponseException,
													FailedUpdatePingException {
		Hashtable table;
		if (result instanceof java.util.Hashtable) {
			table = (Hashtable)result;
		} else {
			throw new UpdatePingResponseException("бƤʤեޥåȤΥ쥹ݥ󥹤֤ޤ");
		}

		String message = (String)table.get("message");
		Boolean flerror = (Boolean)table.get("flerror");

		// Ping 
		if (!flerror.booleanValue()) {
			return message;
		}
		// Ping 
		throw new FailedUpdatePingException(message);
	}

	/**
	 * @param client
	 * @param params
	 * @return RPC ¹Է̥֥
	 * @throws UpdatePingException 
	 */
	private Object execute(XmlRpcClient client, Vector params) throws UpdatePingException {
		try {
			return client.execute(PING_METHOD_NAME, params);
		} catch (XmlRpcException e) {
			throw new UpdatePingException("Ф顼֤ޤ", e);
		} catch (IOException e) {
			throw new ConnectionException(
					"ФȤ³˼ԤޤФURLޤФRPC򥵥ݡȤƤ뤫ǧƤ", e);
		}
	}

	/**
	 * @param serverUrl
	 * @return XmlRpcClient
	 * @throws ConnectionException 
	 */
	protected XmlRpcClient getRpcClient(String serverUrl) throws ConnectionException {
		XmlRpc.setDebug(debug);
		XmlRpc.setEncoding(charset);
		try {
			return new XmlRpcClient(serverUrl);
		} catch (MalformedURLException e) {
			throw new ConnectionException("ꤵ줿ФURLޤ", e);
		}
	}

}