package com.ozacc.blog.trackback;

import java.io.UnsupportedEncodingException;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ȥåХåPing򰷤桼ƥƥ᥽åɷ
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackUtils.java,v 1.5.2.5 2004/12/08 07:14:41 otsuka Exp $
 */
public class TrackBackUtils {

	private static Log log = LogFactory.getLog(TrackBackUtils.class);

	/**
	 * ȥåХåcharsetѥ᡼ʸɤåȤƤʤä
	 * ѤǥեȤʸɡ
	 */
	private static final String DEFAULT_CHARSET = "UTF-8";

	/**
	 * 󥹥ȥ饯̾ѤɬפϤޤ
	 */
	private TrackBackUtils() {}

	/**
	 * HttpServletRequest˥åȤ줿ѥ᡼ͤTrackBackPing֥Ȥޤ
	 * <p>
	 * urlexcerptblog_nametitleγƥѥ᡼ꥯȤ˥åȤƤʤǤ⡢
	 * ͤnullΤޤޤTrackBackPing󥹥󥹤֤ޤ
	 * 
	 * @param request TrackBackPingǡäHttpServletRequest
	 * @return TrackBackPing
	 */
	public static TrackBackPing getTrackBackPingFromRequest(HttpServletRequest request) {
		String charset = request.getParameter("charset");
		String url = request.getParameter("url");
		String excerpt = request.getParameter("excerpt");
		String blogName = request.getParameter("blog_name");
		String title = request.getParameter("title");

		TrackBackPing ping = new TrackBackPing(title, excerpt, url, blogName);
		ping.setCharset(charset);
		return ping;
	}

	/**
	 * ꤵ줿ʸISO-8859-1ꤵ줿ʸɤѴ֤ޤ
	 * 
	 * @param charset Ѵʸ
	 * @param str Ѵʸ
	 * @return Ѵʸ
	 * @throws UnsupportedEncodingException ꤵ줿ʸɤݡȤƤʤ
	 */
	public static String convertCharset(String charset, String str)
																	throws UnsupportedEncodingException {
		if (str != null) {
			log.debug("ʸɤѴޤ[string='" + str + "', charset='" + charset + "']");
			String result = new String(str.getBytes("8859_1"), charset);
			log.debug("ʸɤѴޤ[string='" + result + "', charset='" + charset + "']");
			return result;
		}
		return str;
	}

	/**
	 * ȥåХåPing쥹ݥXML֤ޤ
	 * 
	 * @return ȥåХåPing쥹ݥXML
	 */
	public static String getSuccessResponse() {
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		buf.append("<response>\n");
		buf.append("<error>0</error>\n");
		buf.append("</response>");
		return buf.toString();
	}

	/**
	 * ȥåХåPingԥ쥹ݥXML֤ޤ
	 * 
	 * @param message 쥹ݥ󥹤˴ޤ륨顼å
	 * @return ȥåХåPingԥ쥹ݥXML
	 */
	public static String getErrorResponse(String message) {
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
		buf.append("<response>\n");
		buf.append("<error>1</error>\n");
		buf.append("<message>").append(message).append("</message>\n");
		buf.append("</response>");
		return buf.toString();
	}

	/**
	 * ꥯȥ᥽åɤGETǡ __mode=rss ѥ᡼ꥯȤꤵƤ뤫ɤȽꤷޤ
	 * 
	 * @param request
	 * @return __mode=rss ѥ᡼ꤵƤ true
	 */
	public static boolean isRSSMode(HttpServletRequest request) {
		if ("GET".equalsIgnoreCase(request.getMethod())) {
			String mode = request.getParameter("__mode");
			return "rss".equals(mode);
		}
		return false;
	}

}