package com.ozacc.blog.util;

import org.apache.commons.httpclient.HttpStatus;

/**
 * commons-httpclientλѻѤ桼ƥƥ饹
 * 
 * @since 1.2.4
 * @author Tomohiro Otsuka
 * @version $Id: CommonsHttpClientUtils.java,v 1.1.2.1 2004/12/09 14:27:52 otsuka Exp $
 */
public class CommonsHttpClientUtils {

	private CommonsHttpClientUtils() {};

	/**
	 * ꤵ줿commons-httpclientΥ쥹ݥ󥹥ɤ򼨤ΤɤȽꤷޤ
	 * 
	 * @param statusCode commons-httpclientΥ쥹ݥ󥹥
	 * @param followRedirect 쥯ȥ쥹ݥ󥹤Ȥߤʤ true 
	 * @return 򼨤쥹ݥ󥹥ɤξ true
	 */
	public static boolean isSuccessfulResponse(int statusCode, boolean followRedirect) {
		if (followRedirect) {
			return (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_MOVED_TEMPORARILY
					|| statusCode == HttpStatus.SC_MOVED_PERMANENTLY || statusCode == HttpStatus.SC_TEMPORARY_REDIRECT);
		} else {
			return statusCode == HttpStatus.SC_OK;
		}
	}
}