/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import com.ozacc.mail.fetch.impl.sk_jp.MailUtility;
import com.ozacc.mail.fetch.impl.sk_jp.MultipartUtility;
import com.ozacc.mail.fetch.impl.sk_jp.PartHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;

public class AttachmentsExtractor
implements PartHandler {
    public static final int MODE_IGNORE_MESSAGE = 1;
    public static final int MODE_IGNORE_INLINE = 2;
    private final int mode;
    private final List attachmentParts = new ArrayList();

    public AttachmentsExtractor() {
        this(0);
    }

    public AttachmentsExtractor(int mode) {
        this.mode = mode;
    }

    public boolean processPart(Part part, ContentType context) throws MessagingException, IOException {
        if (part.isMimeType("message/*")) {
            if ((this.mode & 1) != 0) {
                return true;
            }
            this.attachmentParts.add(part);
            return true;
        }
        if (MailUtility.getFileName(part) == null) {
            return true;
        }
        if ((this.mode & 2) != 0 && "inline".equalsIgnoreCase(part.getDisposition())) {
            return true;
        }
        this.attachmentParts.add(part);
        return true;
    }

    public int getCount() {
        return this.attachmentParts.size();
    }

    public String[] getFileNames() throws MessagingException {
        String[] names = new String[this.getCount()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.getFileName(i);
            ++i;
        }
        return names;
    }

    public String getFileName(int index) throws MessagingException {
        Part part = (Part)this.attachmentParts.get(index);
        String name = MailUtility.getFileName(part);
        if (name == null) {
            name = part.isMimeType("message/*") ? "message" + index + ".eml" : "file" + index + ".tmp";
        }
        return name;
    }

    public String getContentType(int index) throws MessagingException {
        return MailUtility.unfold(((Part)this.attachmentParts.get(index)).getContentType());
    }

    public int getSize(int index) throws MessagingException {
        return ((Part)this.attachmentParts.get(index)).getSize();
    }

    public InputStream getInputStream(int index) throws MessagingException, IOException {
        return ((Part)this.attachmentParts.get(index)).getInputStream();
    }

    public void writeTo(int index, OutputStream out) throws MessagingException, IOException {
        int len;
        InputStream in = this.getInputStream(index);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
    }

    public static void main(String[] args) throws Exception {
        MimeMessage msg = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null), System.in);
        AttachmentsExtractor h = new AttachmentsExtractor();
        MultipartUtility.process((Part)msg, h);
        int i = 0;
        while (i < h.getCount()) {
            System.out.println("Attachment no : " + i);
            System.out.println("Filename = " + h.getFileName(i));
            System.out.println("******************");
            h.writeTo(i, System.out);
            ++i;
        }
    }
}

