package com.ozacc.mail.fetch;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import com.ozacc.mail.Mail;

/**
 * ᡼롣
 * <p>
 * <code>FetchMail</code><code>FetchMailPro</code>μ饹Ǽ᡼뤬
 * 󥿡ͥåȥ᡼ȤƤλͤƤʤإå(FromToʤ)ͤåȤƤ硢
 * Υإå˳<code>ReceivedMail</code>󥹥󥹤Υץѥƥˤϲ⥻åȤޤ
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: ReceivedMail.java,v 1.1.2.8 2005/01/22 12:23:14 otsuka Exp $
 */
public class ReceivedMail extends Mail {

	private String replySubjectPrefix = "Re: ";

	private Date date;

	private String messageId;

	private int size;

	private List receivedHeaders;

	private MimeMessage message;

	/**
	 * 󥹥ȥ饯
	 */
	public ReceivedMail() {
		super();
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param charset 
	 */
	public ReceivedMail(String charset) {
		super(charset);
	}

	/**
	 * ԡ󥹥ȥ饯
	 * 
	 * @param original 
	 */
	public ReceivedMail(Mail original) {
		super(original);
	}

	/**
	 * ֤ޤ
	 * <p>
	 * : ᡼μǤϤޤ
	 * 
	 * @return 
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * 򥻥åȤޤ
	 * 
	 * @param date 
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * &lt;&gt;դåID֤ޤ
	 * 
	 * @return &lt;&gt;դåID
	 */
	public String getMessageId() {
		if (messageId.startsWith("<") && messageId.endsWith(">")) {
			return messageId;
		}
		return "<" + messageId + ">";
	}

	/**
	 * åID֤ޤ&lt;&gt;դޤ
	 * 
	 * @return åID
	 */
	public String getMessageIdOnly() {
		if (messageId.startsWith("<") && messageId.endsWith(">")) {
			return messageId.substring(1, messageId.length() - 1);
		}
		return messageId;
	}

	/**
	 * åID򥻥åȤޤ
	 * 
	 * @param messageId åID
	 */
	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	/**
	 * @return Returns the inReplyTo.
	 */
	public String getInReplyTo() {
		return (String)headers.get("In-Reply-To");
	}

	/**
	 * @return Returns the refereces.
	 */
	public String getRefereces() {
		return (String)headers.get("References");
	}

	/**
	 * @return ֿη̾դƬ
	 */
	public String getReplySubjectPrefix() {
		return replySubjectPrefix;
	}

	/**
	 * ֿη̾դƬ򥻥åȤޤ
	 * ǥեȤϡRe: ס
	 * 
	 * @param replySubjectPrefix ֿη̾դƬ
	 */
	public void setReplySubjectPrefix(String replySubjectPrefix) {
		this.replySubjectPrefix = replySubjectPrefix;
	}

	/**
	 * ᡼ƤϤޤ<br>
	 * ᡼Υ˻եޥåȤǽϤޤ
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer(1000);
		buf.append("Mail\n");
		buf.append("Return-Path: ").append(returnPath).append("\n");
		buf.append("Message-ID: ").append(messageId).append("\n");
		buf.append("Date: ").append(date).append("\n");
		buf.append("From: ").append(from != null ? from.toUnicodeString() : null).append("\n");
		buf.append("To: ").append(arrayToCommaDelimitedString(to)).append("\n");
		buf.append("Cc: ").append(arrayToCommaDelimitedString(cc)).append("\n");
		buf.append("Bcc: ").append(arrayToCommaDelimitedString(bcc)).append("\n");
		buf.append("Reply-To: ").append(replyTo != null ? replyTo.toUnicodeString() : null).append(
				"\n");
		buf.append("Subject: ").append(subject).append("\n");

		if (headers != null) {
			for (Iterator itr = headers.keySet().iterator(); itr.hasNext();) {
				String header = (String)itr.next();
				String value = (String)headers.get(header);
				buf.append(header).append(": ").append(value).append("\n");
			}
		}

		buf.append("\n");
		buf.append(text);

		if (htmlText != null) {
			buf.append("\n\n-----\n\n");
			buf.append(htmlText);
		}

		if (isFileAttached()) {
			buf.append("\n\nAttachments\n");
			for (int i = 0, num = attachmentFiles.size(); i < num; i++) {
				AttachmentFile f = (AttachmentFile)attachmentFiles.get(i);
				buf.append("[").append(i + 1).append("] ").append(f.getName()).append("\n");
			}
		}

		return buf.toString();
	}

	/**
	 * @return Returns the message.
	 */
	public MimeMessage getMessage() {
		return message;
	}

	/**
	 * @param message The message to set.
	 */
	public void setMessage(MimeMessage message) {
		this.message = message;
	}

	/**
	 * ᡼륵ФȤ³ǻˡΥ᡼᡼륵Фޤ
	 * Ǥ褦꤬Ǥ true ֤ޤ
	 * <p>
	 * Υ᥽åɤϡ<code>FetchMailPro</code>Υ᥽åɤˤäƼ줿
	 * <code>ReceivedMail</code>󥹥󥹤ǤΤͭǤ
	 * ޤ<code>FetchMailPro</code>󥹥󥹤᡼륵Ф
	 * ³Ƥ֤ǤθƤӽФΤͭǤ<br>
	 * ξ郎ʤˤΥ᥽åɤƤӽФ줿
	 * false ֤ޤ
	 * 
	 * TODO: ޤưƤʤ
	 * 
	 * @see FetchMailPro
	 * @param delete 褦ꤹ true
	 * @return ꤬˹Ԥ줿 true
	 */
	public boolean setDelete(boolean delete) {
		if (message != null) {
			try {
				message.setFlag(Flags.Flag.DELETED, delete);
			} catch (MessagingException e) {
				return false;
			}
			return true;
		}
		return false;
	}

	/**
	 * ᡼Υ()֤ޤñ̤byte
	 * ͤϸ̩ʤΤǤϤʤΤդƤ
	 * 
	 * @see MimeMessage#getSize()
	 * @return ᡼Υ(ñ̤byte)
	 */
	public int getSize() {
		return size;
	}

	/**
	 * ᡼Υ()򥻥åȤޤñ̤byte
	 * 
	 * @param size ᡼Υ(ñ̤byte)
	 */
	public void setSize(int size) {
		this.size = size;
	}

	/**
	 * źեեFile󥹥֤ޤ
	 * źեե뤬ʤ϶֤ޤ
	 * 
	 * @return źեեFile󥹥
	 */
	public File[] getFiles() {
		AttachmentFile[] aFiles = getAttachmentFiles();
		File[] files = new File[aFiles.length];
		for (int i = 0; i < aFiles.length; i++) {
			AttachmentFile aFile = aFiles[i];
			files[i] = aFile.getFile();
		}
		return files;
	}

	/**
	 * Υ᡼ֿ᡼Mail󥹥󥹤֤ޤ
	 * <ul>
	 * <li>(Toɥ쥹)ˤϡΥ᡼Reply-ToޤFromåȤޤ</li>
	 * <li>̾ˤϡΥ᡼η̾ʸʸ鷺Re:פǻϤޤäƤʤСRe: פƬդ̾åȤޤRe:פǻϤޤäƤˤϡη̾򤽤ΤޤޥåȤޤ</li>
	 * <li>ʸˤϡ⥻åȤޤ</li>
	 * <li>Υ᡼Message-IDåȤƤСIn-Reply-ToإåˤͤåȤޤ</li>
	 * <li>Υ᡼Message-IDåȤƤСReferencesإåˤͤäޤ</li>
	 * </ul>
	 * 
	 * @return ֿѤMail󥹥
	 */
	public Mail reply() {
		Mail mail = new Mail();

		// 
		if (getReplyTo() != null) {
			mail.addTo(getReplyTo());
		} else {
			mail.addTo(getFrom());
		}

		// ̾
		String subject = getSubject();
		if ((subject.length() >= 3 && !"Re:".equalsIgnoreCase(subject.substring(0, 3)))
				|| subject.length() < 3) {
			subject = replySubjectPrefix + subject;
		}
		mail.setSubject(subject);

		// In-Reply-To, References
		String messageId = getMessageId();
		if (messageId != null && !"<>".equals(messageId)) {
			String references = getRefereces();
			if (references != null) {
				references = messageId + " " + references;
			} else if (getInReplyTo() != null) {
				references = messageId + " " + getInReplyTo();
			} else {
				references = messageId;
			}
			mail.addHeader("References", references);
			mail.addHeader("In-Reply-To", messageId);
		}

		return mail;
	}

	/**
	 * Receivedإåեɤɲäޤ
	 * 
	 * @param rh Receivedإåե
	 */
	public void addReceviedHeader(ReceivedHeader rh) {
		if (receivedHeaders == null) {
			receivedHeaders = new ArrayList();
		}
		receivedHeaders.add(rh);
	}

	/**
	 * Receivedإåեɤ֤ޤ<br>
	 * ʬΥ(Υ᡼뤬Ϥ)Υ᡼륵Фé¤Ǥޤ<br>
	 * ᡼뤬ReceivedإåեɤʤޤϲϤǤʤä϶֤ޤ
	 * 
	 * @return Receivedإåեɤ
	 */
	public ReceivedHeader[] getReceivedHeaders() {
		if (receivedHeaders == null) {
			return new ReceivedHeader[0];
		}
		return (ReceivedHeader[])receivedHeaders
				.toArray(new ReceivedHeader[receivedHeaders.size()]);
	}

	/**
	 * Receviedإåեɤɽ饹
	 */
	public static class ReceivedHeader {

		private String from;

		private String by;

		/**
		 * @param from ᡼ФΥۥ̾
		 * @param by ᡼ФΥۥ̾
		 */
		public ReceivedHeader(String from, String by) {
			this.from = from;
			this.by = by;
		}

		/**
		 * @see java.lang.Object#toString()
		 */
		public String toString() {
			return "Sent from " + from + " and received by " + by;
		}

		/**
		 * @return ᡼ФΥۥ̾
		 */
		public String getBy() {
			return by;
		}

		/**
		 * @return ᡼ФΥۥ̾
		 */
		public String getFrom() {
			return from;
		}
	}
}