/*
 * @(#) $Id: CorrectedContentTypeDataSource.java,v 1.1.2.2 2004/10/24 10:27:40 otsuka Exp $
 * $Revision: 1.1.2.2 $
 * Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

/**
 * Content-Type:ŬISO-2022-JPޤ
 * ˡ<PRE>
 * Object o = new DataHandler(
 *               new CorrectedContentTypeDataSource(part, charset)
 *            ).getContent();
 * </PRE><P>Τ褦ˤʤޤ</P><P>
 * åɥդǤϤޤΤѼ¦¾ԤäƤ
 * </P>
 * @author Shin
 * @version $Revision: 1.1.2.2 $ $Date: 2004/10/24 10:27:40 $
 */
class CorrectedContentTypeDataSource implements DataSource, MessageAware {

	protected DataSource source;

	protected String defaultCharset;

	protected String forceCharset;

	public CorrectedContentTypeDataSource() {}

	public CorrectedContentTypeDataSource(DataSource dataSource, String defaultCharset) {
		setDataSource(dataSource);
		setDefaultCharset(defaultCharset);
	}

	public CorrectedContentTypeDataSource(Part part, String defaultCharset)
																			throws MessagingException {
		setPart(part);
		setDefaultCharset(defaultCharset);
	}

	public void setPart(Part part) throws MessagingException {
		// getDataHandler() method creates a implicit DataSource.
		setDataSource(part.getDataHandler().getDataSource());
	}

	public void setDataSource(DataSource newSource) {
		source = newSource;
	}

	public void setDefaultCharset(String defaultCharset) {
		this.defaultCharset = defaultCharset;
	}

	/**
	 * ꤵ줿ʸɤǴ¸ʸɤ񤭤ޤ
	 * 
	 * @param forceCharset ŪŬѤʸ
	 * @author Tomohiro Otsuka
	 */
	public void setForceCharset(String forceCharset) {
		this.forceCharset = forceCharset;
	}

	public String getContentType() {
		ContentType contentType = null;
		try {
			contentType = new ContentType(source.getContentType());
		} catch (ParseException e) {
			return "text/plain; charset=" + defaultCharset;
		}
		String specifiedCharset = contentType.getParameter("charset");
		if (specifiedCharset == null) {
			// Content-Type:¸ߤʤ"text/plain"ˤʤäƤޤ
			// text/plainäʤˤʤ뤬
			// charset=ISO-2022-JPˤϰɽʤ
			contentType.setParameter("charset", defaultCharset);
		} else if (forceCharset != null) {
			contentType.setParameter("charset", forceCharset);
		}
		return contentType.toString();
	}

	public String getName() {
		return source.getName();
	}

	public InputStream getInputStream() throws IOException {
		return source.getInputStream();
	}

	public OutputStream getOutputStream() throws IOException {
		return source.getOutputStream();
	}

	public synchronized MessageContext getMessageContext() {
		if (source instanceof MessageAware) {
			return ((MessageAware)source).getMessageContext();
		}
		throw new RuntimeException(source + " isn't MessageAware.");
	}
}