/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail;

import com.ozacc.mail.impl.ByteArrayDataSource;
import com.ozacc.mail.impl.Cp932;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.activation.URLDataSource;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class Mail {
    public static final String JIS_CHARSET = "ISO-2022-JP";
    public static final String DOCTYPE_PUBLIC = "-//OZACC//DTD MAIL//EN";
    public static final String DOCTYPE_SYSTEM = "http://www.ozacc.com/library/dtd/ozacc-mail.dtd";
    public static final String DOCTYPE_PUBLIC_MULTIPLE = "-//OZACC//DTD MULTIPLE MAILS//EN";
    public static final String DOCTYPE_SYSTEM_MULTIPLE = "http://www.ozacc.com/library/dtd/ozacc-multiple-mails.dtd";
    private String charset = "ISO-2022-JP";
    protected String text;
    protected InternetAddress from;
    protected String subject;
    protected List to;
    protected List cc;
    protected List bcc;
    protected List envelopeTo;
    protected InternetAddress returnPath;
    protected InternetAddress replyTo;
    protected String importance;
    protected Map headers;
    protected String htmlText;
    protected List attachmentFiles;

    public Mail() {
    }

    public Mail(String charset) {
        this();
        this.charset = charset;
    }

    public Mail(Mail original) {
        this.bcc = original.bcc;
        this.cc = original.cc;
        this.charset = original.charset;
        this.from = original.from;
        this.importance = original.importance;
        this.replyTo = original.replyTo;
        this.returnPath = original.returnPath;
        this.subject = original.subject;
        this.text = original.text;
        this.to = original.to;
        this.headers = original.headers;
        this.htmlText = original.htmlText;
        this.attachmentFiles = original.attachmentFiles;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setImportance(String importance) throws IllegalArgumentException {
        if (!("high".equals(importance) || "normal".equals(importance) || "low".equals(importance))) {
            throw new IllegalArgumentException("'" + importance + "'\u306f\u3001\u30e1\u30fc\u30eb\u91cd\u8981\u5ea6\u306b\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044\u5024\u3067\u3059\u3002");
        }
        this.importance = importance;
    }

    public String getImportance() {
        return this.importance;
    }

    public void addTo(InternetAddress address) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        this.to.add(address);
    }

    public void addTo(String email) throws IllegalArgumentException {
        try {
            this.addTo(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void addTo(String email, String name) throws IllegalArgumentException {
        if (this.charset.equals(JIS_CHARSET)) {
            name = Cp932.toJIS(name);
        }
        try {
            this.addTo(new InternetAddress(email, name, this.charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress[] getTo() {
        if (this.to == null) {
            return new InternetAddress[0];
        }
        return this.to.toArray(new InternetAddress[this.to.size()]);
    }

    public void addCc(InternetAddress address) {
        if (this.cc == null) {
            this.cc = new ArrayList();
        }
        this.cc.add(address);
    }

    public void addCc(String email) throws IllegalArgumentException {
        try {
            this.addCc(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void addCc(String email, String name) throws IllegalArgumentException {
        if (this.charset.equals(JIS_CHARSET)) {
            name = Cp932.toJIS(name);
        }
        try {
            this.addCc(new InternetAddress(email, name, this.charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress[] getCc() {
        if (this.cc == null) {
            return new InternetAddress[0];
        }
        return this.cc.toArray(new InternetAddress[this.cc.size()]);
    }

    public void addBcc(InternetAddress address) {
        if (this.bcc == null) {
            this.bcc = new ArrayList();
        }
        this.bcc.add(address);
    }

    public void addBcc(String email) throws IllegalArgumentException {
        try {
            this.addBcc(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress[] getBcc() {
        if (this.bcc == null) {
            return new InternetAddress[0];
        }
        return this.bcc.toArray(new InternetAddress[this.bcc.size()]);
    }

    public void setFrom(InternetAddress address) {
        this.from = address;
    }

    public void setFrom(String email) throws IllegalArgumentException {
        try {
            this.setFrom(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void setFrom(String email, String name) throws IllegalArgumentException {
        if (this.charset.equals(JIS_CHARSET)) {
            name = Cp932.toJIS(name);
        }
        try {
            this.setFrom(new InternetAddress(email, name, this.charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public void setReturnPath(InternetAddress address) {
        this.returnPath = address;
    }

    public void setReturnPath(String email) throws IllegalArgumentException {
        try {
            this.setReturnPath(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress getReturnPath() {
        return this.returnPath;
    }

    public void setReplyTo(InternetAddress address) {
        this.replyTo = address;
    }

    public void setReplyTo(String email) throws IllegalArgumentException {
        try {
            this.setReplyTo(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public InternetAddress getReplyTo() {
        return this.replyTo;
    }

    public String getSubject() {
        if (this.subject == null) {
            return "";
        }
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getText() {
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void addXHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        if (name.startsWith("X-")) {
            this.headers.put(name, value);
        } else {
            this.headers.put("X-" + name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(name, value);
    }

    public Map getHeaders() {
        if (this.headers == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.headers);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("Mail\n");
        buf.append("Return-Path: ").append(this.returnPath).append("\n");
        buf.append("From: ").append(this.from != null ? this.from.toUnicodeString() : null).append("\n");
        buf.append("To: ").append(this.arrayToCommaDelimitedString(this.to)).append("\n");
        buf.append("Cc: ").append(this.arrayToCommaDelimitedString(this.cc)).append("\n");
        buf.append("Bcc: ").append(this.arrayToCommaDelimitedString(this.bcc)).append("\n");
        buf.append("Subject: ").append(this.subject).append("\n");
        if (this.headers != null) {
            Iterator itr = this.headers.keySet().iterator();
            while (itr.hasNext()) {
                String header = (String)itr.next();
                String value = (String)this.headers.get(header);
                buf.append(header).append(": ").append(value).append("\n");
            }
        }
        buf.append("\n");
        buf.append(this.text);
        if (this.htmlText != null) {
            buf.append("\n\n-----\n\n");
            buf.append(this.htmlText);
        }
        return buf.toString();
    }

    protected String arrayToCommaDelimitedString(List list) {
        if (list == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int num = list.size();
        while (i < num) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(((InternetAddress)list.get(i)).toUnicodeString());
            ++i;
        }
        return sb.toString();
    }

    public void clearTo() {
        this.to = null;
    }

    public void clearCc() {
        this.cc = null;
    }

    public void clearBcc() {
        this.bcc = null;
    }

    public void setHtmlText(String htmlText) {
        this.htmlText = htmlText;
    }

    public String getHtmlText() {
        return this.htmlText;
    }

    public void addFile(File file) {
        if (this.attachmentFiles == null) {
            this.initAttachmentFiles();
        }
        this.addFile(file, file.getName());
    }

    public void addFile(File file, String fileName) {
        if (this.attachmentFiles == null) {
            this.initAttachmentFiles();
        }
        this.attachmentFiles.add(new AttachmentFile(fileName, file));
    }

    public void addFile(URL url, String fileName) {
        if (this.attachmentFiles == null) {
            this.initAttachmentFiles();
        }
        this.attachmentFiles.add(new AttachmentFile(fileName, url));
    }

    public void addFile(InputStream is, String fileName) {
        if (this.attachmentFiles == null) {
            this.initAttachmentFiles();
        }
        this.attachmentFiles.add(new AttachmentFile(fileName, is));
    }

    private void initAttachmentFiles() {
        this.attachmentFiles = new ArrayList();
    }

    public AttachmentFile[] getAttachmentFiles() {
        if (this.attachmentFiles == null) {
            return new AttachmentFile[0];
        }
        return this.attachmentFiles.toArray(new AttachmentFile[this.attachmentFiles.size()]);
    }

    public boolean isHtmlMail() {
        return this.htmlText != null;
    }

    public boolean isFileAttached() {
        return this.attachmentFiles != null && this.attachmentFiles.size() > 0;
    }

    public boolean isMultipartMail() {
        return this.isHtmlMail() || this.isFileAttached();
    }

    public void clearFile() {
        this.initAttachmentFiles();
    }

    public void addEnvelopeTo(InternetAddress address) {
        if (this.envelopeTo == null) {
            this.envelopeTo = new ArrayList();
        }
        this.envelopeTo.add(address);
    }

    public void addEnvelopeTo(String email) {
        try {
            this.addEnvelopeTo(new InternetAddress(email));
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void addEnvelopeTo(InternetAddress[] addresses) {
        int i = 0;
        while (i < addresses.length) {
            this.addEnvelopeTo(addresses[i]);
            ++i;
        }
    }

    public void addEnvelopeTo(String[] emails) {
        int i = 0;
        while (i < emails.length) {
            this.addEnvelopeTo(emails[i]);
            ++i;
        }
    }

    public void clearEnvelopeTo() {
        this.envelopeTo = null;
    }

    public InternetAddress[] getEnvelopeTo() {
        if (this.envelopeTo == null) {
            return new InternetAddress[0];
        }
        return this.envelopeTo.toArray(new InternetAddress[this.envelopeTo.size()]);
    }

    public class AttachmentFile {
        private String name;
        private File file;
        private InputStream is;
        private URL url;

        public AttachmentFile(String name, File file) {
            this.name = name;
            this.file = file;
        }

        public AttachmentFile(String name, InputStream is) {
            this.name = name;
            this.is = is;
        }

        public AttachmentFile(String name, URL url) {
            this.name = name;
            this.url = url;
        }

        public DataSource getDataSource() {
            if (this.file != null) {
                return new FileDataSource(this.file);
            }
            if (this.url != null) {
                return new URLDataSource(this.url);
            }
            String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(this.name);
            return new ByteArrayDataSource(this.is, contentType);
        }

        public String getName() {
            return this.name;
        }

        public File getFile() {
            return this.file;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public URL getUrl() {
            return this.url;
        }
    }

    public static class Importance {
        public static final String HIGH = "high";
        public static final String NORMAL = "normal";
        public static final String LOW = "low";
    }
}

