/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch;

import com.ozacc.mail.Mail;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class ReceivedMail
extends Mail {
    private String replySubjectPrefix = "Re: ";
    private Date date;
    private String messageId;
    private int size;
    private List receivedHeaders;
    private MimeMessage message;

    public ReceivedMail() {
    }

    public ReceivedMail(String charset) {
        super(charset);
    }

    public ReceivedMail(Mail original) {
        super(original);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getMessageId() {
        if (this.messageId.startsWith("<") && this.messageId.endsWith(">")) {
            return this.messageId;
        }
        return "<" + this.messageId + ">";
    }

    public String getMessageIdOnly() {
        if (this.messageId.startsWith("<") && this.messageId.endsWith(">")) {
            return this.messageId.substring(1, this.messageId.length() - 1);
        }
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getInReplyTo() {
        return (String)this.headers.get("In-Reply-To");
    }

    public String getRefereces() {
        return (String)this.headers.get("References");
    }

    public String getReplySubjectPrefix() {
        return this.replySubjectPrefix;
    }

    public void setReplySubjectPrefix(String replySubjectPrefix) {
        this.replySubjectPrefix = replySubjectPrefix;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("Mail\n");
        buf.append("Return-Path: ").append(this.returnPath).append("\n");
        buf.append("Message-ID: ").append(this.messageId).append("\n");
        buf.append("Date: ").append(this.date).append("\n");
        buf.append("From: ").append(this.from != null ? this.from.toUnicodeString() : null).append("\n");
        buf.append("To: ").append(this.arrayToCommaDelimitedString(this.to)).append("\n");
        buf.append("Cc: ").append(this.arrayToCommaDelimitedString(this.cc)).append("\n");
        buf.append("Bcc: ").append(this.arrayToCommaDelimitedString(this.bcc)).append("\n");
        buf.append("Reply-To: ").append(this.replyTo != null ? this.replyTo.toUnicodeString() : null).append("\n");
        buf.append("Subject: ").append(this.subject).append("\n");
        if (this.headers != null) {
            Iterator itr = this.headers.keySet().iterator();
            while (itr.hasNext()) {
                String header = (String)itr.next();
                String value = (String)this.headers.get(header);
                buf.append(header).append(": ").append(value).append("\n");
            }
        }
        buf.append("\n");
        buf.append(this.text);
        if (this.htmlText != null) {
            buf.append("\n\n-----\n\n");
            buf.append(this.htmlText);
        }
        if (this.isFileAttached()) {
            buf.append("\n\nAttachments\n");
            int i = 0;
            int num = this.attachmentFiles.size();
            while (i < num) {
                Mail.AttachmentFile f = (Mail.AttachmentFile)this.attachmentFiles.get(i);
                buf.append("[").append(i + 1).append("] ").append(f.getName()).append("\n");
                ++i;
            }
        }
        return buf.toString();
    }

    public MimeMessage getMessage() {
        return this.message;
    }

    public void setMessage(MimeMessage message) {
        this.message = message;
    }

    public boolean setDelete(boolean delete) {
        if (this.message != null) {
            try {
                this.message.setFlag(Flags.Flag.DELETED, delete);
            }
            catch (MessagingException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public File[] getFiles() {
        Mail.AttachmentFile[] aFiles = this.getAttachmentFiles();
        File[] files = new File[aFiles.length];
        int i = 0;
        while (i < aFiles.length) {
            Mail.AttachmentFile aFile = aFiles[i];
            files[i] = aFile.getFile();
            ++i;
        }
        return files;
    }

    public Mail reply() {
        Mail mail = new Mail();
        if (this.getReplyTo() != null) {
            mail.addTo(this.getReplyTo());
        } else {
            mail.addTo(this.getFrom());
        }
        String subject = this.getSubject();
        if (subject.length() >= 3 && !"Re:".equalsIgnoreCase(subject.substring(0, 3)) || subject.length() < 3) {
            subject = String.valueOf(this.replySubjectPrefix) + subject;
        }
        mail.setSubject(subject);
        String messageId = this.getMessageId();
        if (messageId != null && !"<>".equals(messageId)) {
            String references = this.getRefereces();
            references = references != null ? String.valueOf(messageId) + " " + references : (this.getInReplyTo() != null ? String.valueOf(messageId) + " " + this.getInReplyTo() : messageId);
            mail.addHeader("References", references);
            mail.addHeader("In-Reply-To", messageId);
        }
        return mail;
    }

    public void addReceviedHeader(ReceivedHeader rh) {
        if (this.receivedHeaders == null) {
            this.receivedHeaders = new ArrayList();
        }
        this.receivedHeaders.add(rh);
    }

    public ReceivedHeader[] getReceivedHeaders() {
        if (this.receivedHeaders == null) {
            return new ReceivedHeader[0];
        }
        return this.receivedHeaders.toArray(new ReceivedHeader[this.receivedHeaders.size()]);
    }

    public static class ReceivedHeader {
        private String from;
        private String by;

        public ReceivedHeader(String from, String by) {
            this.from = from;
            this.by = by;
        }

        public String toString() {
            return "Sent from " + this.from + " and received by " + this.by;
        }

        public String getBy() {
            return this.by;
        }

        public String getFrom() {
            return this.from;
        }
    }
}

