package com.ozacc.mail.impl;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.FactoryConfigurationError;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.MultipleMailBuilder;

/**
 * ᡼ǡXMLե뤫Mail󥹥󥹤륯饹
 * <p>
 * XMLɤ߹ݤˡDTDХǡ󤬼¹ԤޤΤXMLǡ(Valid XML Document)ǤʤФޤ
 * ᡼ǡXMLDTDϡ<a href="http://www.ozacc.com/library/dtd/ozacc-mail.dtd">http://www.ozacc.com/library/dtd/ozacc-mail.dtd</a>򻲾ȡ
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailBuilderImpl.java,v 1.5.2.1 2005/01/21 22:16:31 otsuka Exp $
 */
public class XMLMailBuilderImpl extends AbstractXMLMailBuilder implements MultipleMailBuilder {

	private static Log log = LogFactory.getLog(XMLMailBuilderImpl.class);

	/**
	 * 󥹥ȥ饯
	 */
	public XMLMailBuilderImpl() {
		super();
	}

	/**
	 * @see com.ozacc.mail.MailBuilder#buildMail(java.lang.String)
	 */
	public Mail buildMail(String classPath) throws MailBuildException {
		Document doc = retrieveDocument(classPath);
		return buildMail(doc.getDocumentElement());
	}

	/**
	 * @see com.ozacc.mail.MailBuilder#buildMail(java.io.File)
	 */
	public Mail buildMail(File file) throws MailBuildException {
		Document doc = retrieveDocument(file);
		return buildMail(doc.getDocumentElement());
	}

	/**
	 * @param classPath
	 * @return 
	 * @throws MailBuildException
	 */
	private Document retrieveDocument(String classPath) throws MailBuildException {
		try {
			return getDocumentFromClassPath(classPath);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}
	}

	/**
	 * @param file
	 * @return 
	 * @throws MailBuildException
	 */
	private Document retrieveDocument(File file) throws MailBuildException {
		try {
			return getDocumentFromFile(file);
		} catch (SAXException e) {
			throw new MailBuildException("XMLΥѡ˼Ԥޤ" + e.getMessage(), e);
		} catch (IOException e) {
			throw new MailBuildException("XMLեɤ߹ߤ˼Ԥޤ", e);
		}
	}

	/**
	 * ꤵ줿XMLmailǤMail󥹥󥹤ޤ
	 * 
	 * @param root ᡼ǡmail
	 * @return 줿Mail󥹥
	 */
	protected Mail buildMail(Element root) {
		Mail mail = new Mail();
		setReturnPath(root, mail);
		setFrom(root, mail);
		setRecipients(root, mail);
		setReplyTo(root, mail);
		setSubject(root, mail);
		setText(root, mail);
		setHtml(root, mail);
		return mail;
	}

	/**
	 * @see com.ozacc.mail.MultipleMailBuilder#buildMail(java.lang.String, java.lang.String)
	 */
	public Mail buildMail(String classPath, String mailId) throws MailBuildException {
		if (mailId == null || "".equals(mailId)) {
			throw new IllegalArgumentException("᡼IDꤵƤޤ");
		}
		Document doc = retrieveDocument(classPath);
		if (Mail.DOCTYPE_PUBLIC.equals(doc.getDoctype().getPublicId())) {
			throw new MailBuildException("ꤵ줿饹ѥXMLϥ󥰥᡼ƥץ졼ȤǤ[classPath='" + classPath
					+ "']");
		}
		Element mailElem = doc.getElementById(mailId);
		return buildMail(mailElem);
	}

	/**
	 * @see com.ozacc.mail.MultipleMailBuilder#buildMail(java.io.File, java.lang.String)
	 */
	public Mail buildMail(File file, String mailId) throws MailBuildException {
		if (mailId == null || "".equals(mailId)) {
			throw new IllegalArgumentException("᡼IDꤵƤޤ");
		}
		Document doc = retrieveDocument(file);
		if (Mail.DOCTYPE_PUBLIC.equals(doc.getDoctype().getPublicId())) {
			throw new MailBuildException("ꤵ줿եXMLϥ󥰥᡼ƥץ졼ȤǤ[filePath='"
					+ file.getAbsolutePath() + "']");
		}
		return buildMail(doc, mailId);
	}

	/**
	 * ޥץ᡼ƥץ졼ȤXMLɥȾλꤵ줿ID᡼ƥץ졼ȤMail󥹥󥹤֤ޤ
	 * 
	 * @param doc
	 * @param mailId
	 * @return 줿Mail󥹥
	 * @throws FactoryConfigurationError 
	 */
	protected Mail buildMail(Document doc, String mailId) throws FactoryConfigurationError {
		Element mailElem = doc.getElementById(mailId);
		if (mailElem == null) {
			throw new MailBuildException("ꤵ줿ID[" + mailId + "]Υ᡼ǡϸĤޤǤ");
		}
		log.debug(mailElem);
		return buildMail(mailElem);
	}

}