package com.ozacc.mail;

import java.io.File;

import org.apache.velocity.VelocityContext;

/**
 * VelocityϢȤưŪ˥᡼ǡΥǡMail󥹥󥹤륤󥿡ե
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: VelocityMultipleMailBuilder.java,v 1.1.2.2 2005/01/23 06:47:08 otsuka Exp $
 */
public interface VelocityMultipleMailBuilder extends VelocityMailBuilder {

	/**
	 * ꤵ줿饹ѥΥեɤ߹ߡmailIdǡMail󥹥󥹤ޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param classPath ᡼Ƥ򵭽ҤեΥѥ
	 * @param context VelocityContext
	 * @param mailId MailΥ᡼ǡ򼨤ID
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	Mail buildMail(String classPath, VelocityContext context, String mailId)
																			throws MailBuildException;

	/**
	 * ꤵ줿եɤ߹ߡmailIdǡMail󥹥󥹤ޤ
	 * ꤵ줿VelocityContextȤäơXMLեƤưŪǤޤ
	 * 
	 * @param file ᡼Ƥ򵭽Ҥե
	 * @param context VelocityContext
	 * @param mailId MailΥ᡼ǡ򼨤ID
	 * @return 줿Mail󥹥
	 * @throws MailBuildException Mail󥹥󥹤˼Ԥ
	 */
	Mail buildMail(File file, VelocityContext context, String mailId) throws MailBuildException;

}