/*
 * @(#) $Id: StringValues.java,v 1.1.2.1 2005/01/18 07:20:49 otsuka Exp $
 * $Revision: 1.1.2.1 $
 */
package com.ozacc.mail.fetch.impl.sk_jp.util;

import java.util.*;

/**
 * StringValues.
 * <p>
 * ʣʸ򥫥ޤ䥿ֶڤʤɤΰĤʸȤƴǽȤޤ
 * <br>ŪˤListޤΤindexˤ륢ǽǤ
 * ۻڤgetString()˶ڤʸǰܤˤ줿ʸȤ
 * Ȥꤹ뤳ȤǤޤ
 * ׽ʤΤǡǥߥޤȡǧǤޤ
 * </p>
 * @version $Revision: 1.1.2.1 $ $Date: 2005/01/18 07:20:49 $
 * @author Shin
 */
public class StringValues {
    private List                src_ = new ArrayList();
    /**
     * ʣʸ֥Ȥޤ
     */
    public StringValues() {}
    /**
     * ʣʸ֥Ȥޤ
     * @param str ڤʸϢ뤵줿ʸ
     */
    public StringValues(String str) {
        parse(str);
    }
    /**
     * ʣʸ֥Ȥޤ
     * @param str ڤʸϢ뤵줿ʸ
     * @param delim ǥߥ
     */
    public StringValues(String str, String delim) {
        parse(str, delim);
    }
    /**
     * ʣʸ֥Ȥޤ
     * @param strings ʸ
     */
    public StringValues(String[] strings) {
        add(strings);
    }
    /**
     * ʣʸ֥Ȥޤ
     * @param strings ʸ
     */
    public StringValues(Object[] o) {
        for (int i = 0; i < o.length; i++) {
            add(o[i].toString());
        }
    }
//////////////////////////////////////////////////////////////////////////////
    /**
     * ǥߥǶڤ줿ʸʬ䤷ɲäޤ
     * <p>
     * ǥߥStringTokenizerɸΥǥߥ
     * <code>"&#92;t&#92;n&#92;r&#92;f"</code>Ȥޤ
     * </p>
     * @param str ڤʸϢ뤵줿ʸ
     * @param delim ǥߥ
     */
    public void parse(String str) {
        StringTokenizer         st = new StringTokenizer(str);
        parse(st);
    }
    /**
     * ǥߥǶڤ줿ʸʬ䤷ɲäޤ
     * <p>
     * </p>
     * @param str ڤʸϢ뤵줿ʸ
     * @param delim ǥߥ
     */
    public void parse(String str, String delim) {
        StringTokenizer         st = new StringTokenizer(str, delim);
        parse(st);
    }
    private void parse(StringTokenizer st) {
        while (st.hasMoreTokens()) {
            add(st.nextToken());
        }
    }
    /**
     * ʸ󷲤ؤΥƥ졼֤ޤ
     * @return Iterator֥
     */
    public Iterator iterator() {
        return src_.iterator();
    }

    /**
     * ޶ڤʸޤ
     * <p>
     * ڤʸʸƱΤδ֤ñޤ
     * </p>
     * @return ʸ󲽤֥
     */
    public String getString() {
        return getString(", ");
    }
    /**
     * ꤷڤʸϢ뤵줿ʸޤ
     * <p>
     * ڤʸʸƱΤδ֤ñޤ
     * </p>
     * @param delim ڤʸ
     * @return ʸ󲽤֥
     */
    public String getString(String delim) {
        StringBuffer            buf = new StringBuffer();
        Iterator                iterator = iterator();
        if (iterator.hasNext()) {
            buf.append(iterator.next());
        }
        while (iterator.hasNext()) {
            buf.append(delim).append(iterator.next());
        }
        return new String(buf);
    }
    public String toString() {
        return getString();
    }
    /**
     * indexʸޤ
     * @param index ʸΰ
     */
    public String get(int index) {
        return (String)src_.get(index);
    }
    /**
     * ʸɲäޤ
     * @param str ɲäʸ
     */
    public void add(String str) {
        src_.add(str);
    }
    /**
     * ʸ󷲤ɲäޤ
     * @param str ɲäʸ
     */
    public void add(String[] str) {
        for (int i = 0; i < str.length; i++) {
            src_.add(str[i]);
        }
    }
    /**
     * Ƥʸޤ
     */
    public void clear() {
        src_.clear();
    }
}
