/*
 * @(#) $Id: MultipartUtility.java,v 1.1.2.2 2004/10/24 10:26:50 otsuka Exp $
 * $Revision: 1.1.2.2 $
 * Copyright (c) 2000 Shin Kinoshita All Rights Reserved.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

/**
 * åܥǥФʤ󶡤static᥽åɤΥåȤǤ
 * <p>
 * </p>
 * @version $Revision: 1.1.2.2 $ $Date: 2004/10/24 10:26:50 $
 * @author Shin
 * @author Tomohiro Otsuka
 */
public class MultipartUtility {

	private static final String JIS_CHARSET = "ISO-2022-JP";

	/**
	 * ѡȤΥܥǥ֤ޤ
	 * <P>
	 * Part#getContent()Ǥ
	 * MIME˽򤷤ʤContent-Type:Ԥޤ
	 * charset꤬ʤ"ISO-2022-JP"䤤ޤ
	 * </P><P>
	 * ѡȤUTF-7ξƤޤ
	 * </P>
	 */
	public static Object getContent(Part part) throws MessagingException, IOException {
		return getContent(part, JIS_CHARSET);
	}

	private static CorrectedContentTypeDataSource correctedDataSource = new CorrectedContentTypeDataSourceUTF7Support();

	private static DataHandler correctedDataHandler = new DataHandler(correctedDataSource);

	/**
	 * ѡȤΥܥǥ֤ޤ
	 * <P>
	 * MIME˽򤷤ʤContent-Type:Ԥޤ
	 * charset꤬ʤcharsetǻꤵ줿Τ䤤ޤ
	 * </P><P>
	 * ѡȤUTF-7ξƤޤ
	 * </P>
	 */
	public static Object getContent(Part part, String charset) throws MessagingException,
																IOException {
		synchronized (correctedDataSource) {

			correctedDataSource.setPart(part);
			try {
				correctedDataSource.setDefaultCharset(charset);
				return correctedDataHandler.getContent();
			} catch (UnsupportedEncodingException e) {
				/*
				 * ʸɤcharset˥åȤ㳰줿
				 * JIS_CHARSETʸɤ֤٥ۥǥμߤޤ
				 * 
				 * by otsuka
				 */
				correctedDataSource.setForceCharset(JIS_CHARSET);
				return correctedDataHandler.getContent();
			}

		}
	}

	/**
	 * ѡ۲Ǻǽ˸ĤƥȥѡȤΥܥǥ֤ޤ
	 * process()ƤӽФƷ̤֤convenience methodǤ
	 */
	public static String getFirstPlainText(Part part) throws MessagingException {
		FirstPlainPartExtractor h = new FirstPlainPartExtractor();
		process(part, h);
		return h.getText();
	}

	/**
	 * ѡ۲inlineʥƥȥѡȤ򽸤ɽѤΥܥǥ֤ޤ
	 * process()ƤӽФƷ̤֤convenience methodǤ
	 */
	public static String getPlainText(Part part) throws MessagingException {
		PlainPartExtractor h = new PlainPartExtractor();
		process(part, h);
		return h.getText();
	}

	/**
	 * ѡ۲γƥѡȤޤ
	 * <P>
	 * ٤ƤPartФPartHandlerƤӽФޤ<BR>
	 * </P>
	 */
	public static void process(Part part, PartHandler handler) throws MessagingException {
		process(part, handler, null);
	}

	private static boolean process(Part part, PartHandler handler, ContentType context)
																						throws MessagingException {
		try {
			if (part.isMimeType("multipart/*")) {
				Multipart mp = (Multipart)part.getContent();
				ContentType cType = new ContentType(part.getContentType());
				for (int i = 0; i < mp.getCount(); i++) {
					if (!process(mp.getBodyPart(i), handler, cType)) {
						return false;
					}
				}
				return true;
			}
			return handler.processPart(part, context);
		} catch (IOException e) {
			throw new MessagingException("Got exception \nin " + part + "\n", e);
		}
	}

	/**
	 * partbodyPartɲäޤ
	 * partޥѡȥƥʤξϤΥƥʤbodyPartɲäޤ
	 * ǤʤpartΥܥǥȤmultipart/mixedΥƥʤꤷ
	 * partΥܥǥbodyPartΥܥǥ򤽤Υƥʤɲäޤ
	 */
	public static void addBodyPart(Part part, MimeBodyPart bodyPart) throws MessagingException,
																	IOException {
		if (part.isMimeType("multipart/*")) {
			((MimeMultipart)part.getContent()).addBodyPart(bodyPart);
			return;
		}
		// 
		MimeMultipart mp = new MimeMultipart("mixed");
		MimeBodyPart original = new MimeBodyPart();
		original.setContent(part.getContent(), part.getContentType());
		mp.addBodyPart(original);
		mp.addBodyPart(bodyPart);
		part.setContent(mp);
	}

	/**
	 * partΥĥ꡼¤פǥХåѥ᥽åɤǤ
	 */
	public static void dump(Part part) {
		dump(part, 0);
	}

	private static void dump(Part part, int layer) {
		for (int i = 0; i < layer; i++) {
			System.out.print("    ");
		}
		try {
			System.out.println(part.getClass() + ":" + part.getContentType());
			if (part.isMimeType("multipart/*")) {
				MimeMultipart mp = (MimeMultipart)part.getContent();
				for (int i = 0; i < mp.getCount(); i++) {
					dump(mp.getBodyPart(i), layer + 1);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}