/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp;

import com.ozacc.mail.fetch.impl.sk_jp.CorrectedContentTypeDataSource;
import com.ozacc.mail.fetch.impl.sk_jp.CorrectedContentTypeDataSourceUTF7Support;
import com.ozacc.mail.fetch.impl.sk_jp.FirstPlainPartExtractor;
import com.ozacc.mail.fetch.impl.sk_jp.PartHandler;
import com.ozacc.mail.fetch.impl.sk_jp.PlainPartExtractor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class MultipartUtility {
    private static final String JIS_CHARSET = "ISO-2022-JP";
    private static CorrectedContentTypeDataSource correctedDataSource = new CorrectedContentTypeDataSourceUTF7Support();
    private static DataHandler correctedDataHandler = new DataHandler((DataSource)correctedDataSource);

    public static Object getContent(Part part) throws MessagingException, IOException {
        return MultipartUtility.getContent(part, JIS_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getContent(Part part, String charset) throws MessagingException, IOException {
        CorrectedContentTypeDataSource correctedContentTypeDataSource = correctedDataSource;
        synchronized (correctedContentTypeDataSource) {
            correctedDataSource.setPart(part);
            try {
                correctedDataSource.setDefaultCharset(charset);
                return correctedDataHandler.getContent();
            }
            catch (UnsupportedEncodingException e) {
                correctedDataSource.setForceCharset(JIS_CHARSET);
                return correctedDataHandler.getContent();
            }
        }
    }

    public static String getFirstPlainText(Part part) throws MessagingException {
        FirstPlainPartExtractor h = new FirstPlainPartExtractor();
        MultipartUtility.process(part, h);
        return h.getText();
    }

    public static String getPlainText(Part part) throws MessagingException {
        PlainPartExtractor h = new PlainPartExtractor();
        MultipartUtility.process(part, h);
        return h.getText();
    }

    public static void process(Part part, PartHandler handler) throws MessagingException {
        MultipartUtility.process(part, handler, null);
    }

    private static boolean process(Part part, PartHandler handler, ContentType context) throws MessagingException {
        try {
            if (part.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)part.getContent();
                ContentType cType = new ContentType(part.getContentType());
                int i = 0;
                while (i < mp.getCount()) {
                    if (!MultipartUtility.process((Part)mp.getBodyPart(i), handler, cType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return handler.processPart(part, context);
        }
        catch (IOException e) {
            throw new MessagingException("Got exception \nin " + part + "\n", (Exception)e);
        }
    }

    public static void addBodyPart(Part part, MimeBodyPart bodyPart) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            ((MimeMultipart)part.getContent()).addBodyPart((BodyPart)bodyPart);
            return;
        }
        MimeMultipart mp = new MimeMultipart("mixed");
        MimeBodyPart original = new MimeBodyPart();
        original.setContent(part.getContent(), part.getContentType());
        mp.addBodyPart((BodyPart)original);
        mp.addBodyPart((BodyPart)bodyPart);
        part.setContent((Multipart)mp);
    }

    public static void dump(Part part) {
        MultipartUtility.dump(part, 0);
    }

    private static void dump(Part part, int layer) {
        int i = 0;
        while (i < layer) {
            System.out.print("    ");
            ++i;
        }
        try {
            System.out.println(part.getClass() + ":" + part.getContentType());
            if (part.isMimeType("multipart/*")) {
                MimeMultipart mp = (MimeMultipart)part.getContent();
                int i2 = 0;
                while (i2 < mp.getCount()) {
                    MultipartUtility.dump((Part)mp.getBodyPart(i2), layer + 1);
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

