/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl;

import com.ozacc.mail.fetch.MailConverter;
import com.ozacc.mail.fetch.ReceivedMail;
import com.ozacc.mail.fetch.impl.sk_jp.AttachmentsExtractor;
import com.ozacc.mail.fetch.impl.sk_jp.HtmlPartExtractor;
import com.ozacc.mail.fetch.impl.sk_jp.MailUtility;
import com.ozacc.mail.fetch.impl.sk_jp.MultipartUtility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailConverterImpl
implements MailConverter {
    private static final String ATTACHMENT_DIR_PREFIX = "OML_";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static Log log;
    private static Pattern receivedHeaderPattern;
    private long attachmentLifetime = 43200000L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ozacc.mail.fetch.impl.MailConverterImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        receivedHeaderPattern = Pattern.compile("^from (.+?) .*by (.+?) .*$");
    }

    public ReceivedMail[] convertIntoMails(MimeMessage[] messages) {
        log.debug((Object)("\u8a08" + messages.length + "\u901a\u306eMimeMessage\u3092Mail\u306b\u5909\u63db\u3057\u307e\u3059\u3002"));
        ReceivedMail[] results = new ReceivedMail[messages.length];
        int i = 0;
        while (i < messages.length) {
            log.debug((Object)(String.valueOf(i + 1) + "\u901a\u76ee\u306eMimeMessage\u3092Mail\u306b\u5909\u63db\u3057\u307e\u3059\u3002"));
            results[i] = this.convertIntoMail(messages[i]);
            log.debug((Object)(String.valueOf(i + 1) + "\u901a\u76ee\u306eMimeMessage\u3092Mail\u306b\u5909\u63db\u3057\u307e\u3057\u305f\u3002"));
            log.debug((Object)results[i].toString());
            ++i;
        }
        log.debug((Object)("\u8a08" + messages.length + "\u901a\u306eMimeMessage\u3092Mail\u306b\u5909\u63db\u3057\u307e\u3057\u305f\u3002"));
        return results;
    }

    private void setReceivedHeaders(MimeMessage mm, ReceivedMail mail) {
        String[] headerValues = null;
        try {
            headerValues = mm.getHeader("Received");
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
        if (headerValues != null) {
            int i = 0;
            while (i < headerValues.length) {
                String received = headerValues[i];
                if (received.startsWith("from")) {
                    received = received.replaceAll("\n", "").replaceAll("\\s+", " ");
                    log.debug((Object)("Received='" + received + "'"));
                    Matcher m = receivedHeaderPattern.matcher(received);
                    if (m.matches()) {
                        String from = m.group(1);
                        String by = m.group(2);
                        log.debug((Object)("Sent from '" + from + "', Received by '" + by + "'"));
                        ReceivedMail.ReceivedHeader rh = new ReceivedMail.ReceivedHeader(from, by);
                        mail.addReceviedHeader(rh);
                    }
                }
                ++i;
            }
        }
    }

    private void setAttachmentFiles(MimeMessage mm, ReceivedMail mail) {
        try {
            this.cleanTempDir();
            AttachmentsExtractor ae = new AttachmentsExtractor(1);
            MultipartUtility.process((Part)mm, ae);
            int i = 0;
            int num = ae.getCount();
            while (i < num) {
                String fileName = ae.getFileName(i);
                if (fileName == null || "".equals(fileName)) {
                    fileName = "attachment" + (i + 1) + ".tmp";
                }
                String path = String.valueOf(this.getTempDirPath()) + File.separator + ATTACHMENT_DIR_PREFIX + System.currentTimeMillis() + File.separator + fileName;
                log.debug((Object)(String.valueOf(i + 1) + "\u500b\u76ee\u306e\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3057\u307e\u3059\u3002[" + path + "]"));
                File f = new File(path);
                f.getParentFile().mkdirs();
                InputStream is = ae.getInputStream(i);
                try {
                    this.writeTo(f, is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                f.getParentFile().deleteOnExit();
                f.deleteOnExit();
                mail.addFile(f, fileName);
                log.debug((Object)(String.valueOf(i + 1) + "\u500b\u76ee\u306e\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002[" + path + "]"));
                ++i;
            }
        }
        catch (IOException e) {
            log.error((Object)"\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void cleanTempDir() {
        File tempDir = new File(this.getTempDirPath());
        File[] omlDirs = tempDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(MailConverterImpl.ATTACHMENT_DIR_PREFIX);
            }
        });
        log.debug((Object)("\u73fe\u5728" + omlDirs.length + "\u500b\u306e\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u7528\u30c7\u30a3\u30ec\u30af\u30c8\u30ea[" + tempDir.getAbsolutePath() + "]\u304c\u4e00\u6642\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306b\u5b58\u5728\u3057\u307e\u3059\u3002"));
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < omlDirs.length) {
            File dir = omlDirs[i];
            log.debug((Object)String.valueOf(dir.lastModified()));
            if (now - dir.lastModified() >= this.attachmentLifetime) {
                this.deleteDir(dir);
            }
            ++i;
        }
    }

    private String getTempDirPath() {
        return System.getProperty(JAVA_IO_TMPDIR);
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            f.delete();
            ++i;
        }
        dir.delete();
    }

    private void writeTo(File destFile, InputStream is) throws FileNotFoundException, IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile), 51200);
        try {
            MailConverterImpl.copy(is, bos);
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
    }

    private void setXHeaders(MimeMessage mm, ReceivedMail mail) {
        log.debug((Object)"X-Header\u3092Mail\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3059\u3002");
        Enumeration headerEnum = null;
        try {
            headerEnum = mm.getAllHeaders();
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
        while (headerEnum != null && headerEnum.hasMoreElements()) {
            Header header = (Header)headerEnum.nextElement();
            if (!header.getName().startsWith("X-") && !"References".equalsIgnoreCase(header.getName()) && !"In-Reply-To".equalsIgnoreCase(header.getName())) continue;
            mail.addHeader(header.getName(), header.getValue());
            log.debug((Object)(String.valueOf(header.getName()) + "\u3092Mail\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002[" + header.getName() + "='" + header.getValue() + "']"));
        }
    }

    private void setReplyToAddress(MimeMessage mm, ReceivedMail mail) {
        log.debug((Object)"Reply-To\u30a2\u30c9\u30ec\u30b9\u3092Mail\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3059\u3002");
        Address[] addresses = null;
        try {
            addresses = mm.getReplyTo();
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
        if (addresses != null) {
            log.debug((Object)(String.valueOf(addresses.length) + "\u3064\u306eReply-To\u30a2\u30c9\u30ec\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002\u6700\u521d\u306e\u30a2\u30c9\u30ec\u30b9\u306e\u307f\u53d6\u5f97\u3055\u308c\u307e\u3059\u3002"));
            int j = 0;
            if (j < addresses.length) {
                Address address = addresses[j];
                mail.setReplyTo((InternetAddress)address);
            }
        } else {
            log.debug((Object)"Reply-To\u30a2\u30c9\u30ec\u30b9\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }

    private void setSize(MimeMessage mm, ReceivedMail mail) {
        try {
            mail.setSize(mm.getSize());
        }
        catch (MessagingException e) {
            mail.setSize(-1);
        }
    }

    private void setHtmlText(MimeMessage mm, ReceivedMail mail) {
        try {
            HtmlPartExtractor hpe = new HtmlPartExtractor();
            MultipartUtility.process((Part)mm, hpe);
            String htmlText = hpe.getHtml();
            mail.setHtmlText(htmlText);
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void setText(MimeMessage mm, ReceivedMail mail) {
        try {
            String text = MultipartUtility.getPlainText((Part)mm);
            mail.setText(text);
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void setMessageId(MimeMessage mm, ReceivedMail mail) {
        try {
            String messageId = mm.getMessageID();
            mail.setMessageId(messageId);
            log.debug((Object)("Message-ID\u3092Mail\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002[Message-ID='" + messageId + "']"));
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void setSubject(MimeMessage mm, ReceivedMail mail) {
        try {
            String subject = MailUtility.decodeText(mm.getSubject());
            mail.setSubject(subject);
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void setDate(MimeMessage mm, ReceivedMail mail) {
        try {
            Date d = mm.getSentDate();
            mail.setDate(d);
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
    }

    private void setReturnPath(MimeMessage mm, ReceivedMail mail) {
        log.debug((Object)"Return-Path\u30a2\u30c9\u30ec\u30b9\u3092\u691c\u51fa\u3057\u307e\u3059\u3002");
        String[] returnPath = null;
        try {
            returnPath = mm.getHeader("Return-Path");
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
        if (returnPath != null && returnPath.length > 0) {
            String email = returnPath[0].substring(1, returnPath[0].length() - 1);
            if (email.length() > 0) {
                try {
                    mail.setReturnPath(email);
                    log.debug((Object)("Return-Path\u30a2\u30c9\u30ec\u30b9\u3092Mail\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002[Return-Path='" + email + "']"));
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)("Return-Path\u30a2\u30c9\u30ec\u30b9\u304c\u4e0d\u6b63\u306a\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u3067\u3059\u3002[Return-Path='" + email + "']"));
                }
            } else {
                log.debug((Object)"Return-Path\u30a2\u30c9\u30ec\u30b9\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
        } else {
            log.debug((Object)"Return-Path\u30a2\u30c9\u30ec\u30b9\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }

    private void setFromAddress(MimeMessage mm, ReceivedMail mail) {
        log.debug((Object)"From\u30a2\u30c9\u30ec\u30b9\u3092\u691c\u51fa\u3057\u307e\u3059\u3002");
        Address[] addresses = null;
        try {
            addresses = mm.getFrom();
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
        if (addresses != null) {
            log.debug((Object)(String.valueOf(addresses.length) + "\u3064\u306eFrom\u30a2\u30c9\u30ec\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002"));
            int j = 0;
            while (j < addresses.length) {
                InternetAddress address = (InternetAddress)addresses[j];
                mail.setFrom(address);
                log.debug((Object)("From\u30a2\u30c9\u30ec\u30b9\u3092Mail\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002[From='" + address.toUnicodeString() + "']"));
                ++j;
            }
        } else {
            log.debug((Object)"From\u30a2\u30c9\u30ec\u30b9\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }

    private void setRecipientAddresses(MimeMessage mm, ReceivedMail mail) {
        log.debug((Object)"To\u30a2\u30c9\u30ec\u30b9\u3092\u691c\u51fa\u3057\u307e\u3059\u3002");
        Address[] toAddresses = null;
        try {
            toAddresses = mm.getRecipients(Message.RecipientType.TO);
        }
        catch (AddressException e) {
            log.warn((Object)("\u4e0d\u6b63\u306a\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002[" + e.getRef() + "]"));
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
        if (toAddresses != null) {
            log.debug((Object)(String.valueOf(toAddresses.length) + "\u3064\u306eTo\u30a2\u30c9\u30ec\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002"));
            int j = 0;
            while (j < toAddresses.length) {
                InternetAddress address = (InternetAddress)toAddresses[j];
                mail.addTo(address);
                log.debug((Object)("To\u30a2\u30c9\u30ec\u30b9\u3092Mail\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002[To='" + address.toUnicodeString() + "']"));
                ++j;
            }
        } else {
            log.debug((Object)"To\u30a2\u30c9\u30ec\u30b9\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        log.debug((Object)"Cc\u30a2\u30c9\u30ec\u30b9\u3092\u691c\u51fa\u3057\u307e\u3059\u3002");
        Address[] ccAddresses = null;
        try {
            ccAddresses = mm.getRecipients(Message.RecipientType.CC);
        }
        catch (AddressException e) {
            log.warn((Object)("\u4e0d\u6b63\u306a\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002[" + e.getRef() + "]"));
        }
        catch (MessagingException e) {
            log.warn((Object)e.getMessage());
        }
        if (ccAddresses != null) {
            log.debug((Object)(String.valueOf(ccAddresses.length) + "\u3064\u306eCc\u30a2\u30c9\u30ec\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002"));
            int j = 0;
            while (j < ccAddresses.length) {
                InternetAddress address = (InternetAddress)ccAddresses[j];
                mail.addCc(address);
                log.debug((Object)("Cc\u30a2\u30c9\u30ec\u30b9\u3092Mail\u306b\u30bb\u30c3\u30c8\u3057\u307e\u3057\u305f\u3002[Cc='" + address.toUnicodeString() + "']"));
                ++j;
            }
        } else {
            log.debug((Object)"Cc\u30a2\u30c9\u30ec\u30b9\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }

    public ReceivedMail convertIntoMail(MimeMessage mm) {
        ReceivedMail mail = this.createReceivedMail();
        this.setReturnPath(mm, mail);
        this.setReceivedHeaders(mm, mail);
        this.setDate(mm, mail);
        this.setFromAddress(mm, mail);
        this.setRecipientAddresses(mm, mail);
        this.setMessageId(mm, mail);
        this.setReplyToAddress(mm, mail);
        this.setSubject(mm, mail);
        this.setXHeaders(mm, mail);
        this.setText(mm, mail);
        this.setHtmlText(mm, mail);
        this.setAttachmentFiles(mm, mail);
        this.setSize(mm, mail);
        mail.setMessage(mm);
        return mail;
    }

    protected ReceivedMail createReceivedMail() {
        return new ReceivedMail();
    }
}

