/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.fetch.impl.sk_jp.io;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class CharCodeConverter {
    public static final byte[] SJIS_KANA;

    static {
        try {
            SJIS_KANA = "\u3002\u300c\u300d\u3001\u30fb\u30f2\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7\u30c3\u30fc\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f3\u309b\u309c".getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public static byte[] sjisToJis(byte[] sjisBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean nonAscii = false;
        int len = sjisBytes.length;
        int i = 0;
        while (i < len) {
            if (sjisBytes[i] >= 0) {
                if (nonAscii) {
                    nonAscii = false;
                    out.write(27);
                    out.write(40);
                    out.write(66);
                }
                out.write(sjisBytes[i]);
            } else {
                int b;
                if (!nonAscii) {
                    nonAscii = true;
                    out.write(27);
                    out.write(36);
                    out.write(66);
                }
                if ((b = sjisBytes[i] & 0xFF) >= 161 && b <= 223) {
                    int kanaIndex = (b - 161) * 2;
                    CharCodeConverter.sjisToJis(out, SJIS_KANA[kanaIndex], SJIS_KANA[kanaIndex + 1]);
                } else {
                    if (++i == len) break;
                    CharCodeConverter.sjisToJis(out, sjisBytes[i - 1], sjisBytes[i]);
                }
            }
            ++i;
        }
        if (nonAscii) {
            out.write(27);
            out.write(40);
            out.write(66);
        }
        return out.toByteArray();
    }

    private static void sjisToJis(ByteArrayOutputStream out, byte bh, byte bl) {
        int h = bh << 1 & 0xFF;
        int l = bl & 0xFF;
        if (l < 159) {
            h = h < 63 ? (h += 31) : (h -= 97);
            l = l > 126 ? (l -= 32) : (l -= 31);
        } else {
            h = h < 63 ? (h += 32) : (h -= 96);
            l -= 126;
        }
        out.write(h);
        out.write(l);
    }

    public byte[] jisTosjis(byte[] jisBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean nonAscii = false;
        boolean kana = false;
        int len = jisBytes.length;
        int i = 0;
        while (i < len) {
            if (jisBytes[i] == 27) {
                if (i + 2 >= len) break;
                if (jisBytes[i + 1] == 36 && jisBytes[i + 2] == 66) {
                    nonAscii = true;
                    i += 2;
                } else if (jisBytes[i + 1] == 40 && jisBytes[i + 2] == 73) {
                    kana = true;
                    i += 2;
                } else if (jisBytes[i + 1] == 40 && jisBytes[i + 2] == 66) {
                    nonAscii = false;
                    kana = false;
                    i += 2;
                } else {
                    nonAscii = false;
                    kana = false;
                }
            } else if (jisBytes[i] == 14) {
                kana = true;
            } else if (jisBytes[i] == 15) {
                kana = false;
            } else if (kana) {
                out.write(jisBytes[i] | 0x80);
            } else if (nonAscii) {
                if (++i == jisBytes.length) break;
                CharCodeConverter.jisToSjis(out, jisBytes[i - 1], jisBytes[i]);
            } else {
                out.write(jisBytes[i]);
            }
            ++i;
        }
        return out.toByteArray();
    }

    private static void jisToSjis(ByteArrayOutputStream out, byte bh, byte bl) {
        int h = bh & 0xFF;
        int l = bl & 0xFF;
        if ((h & 1) > 0) {
            h = (h >>= 1) < 47 ? (h += 113) : (h -= 79);
            l = l > 95 ? (l += 32) : (l += 31);
        } else {
            h = (h >>= 1) < 47 ? (h += 112) : (h -= 80);
            l += 126;
        }
        out.write(h);
        out.write(l);
    }
}

