package com.ozacc.blog.feed.impl;

import java.net.URL;
import java.util.Date;

import com.ozacc.blog.feed.Item;
import com.ozacc.blog.util.XmlUtils;

/**
 * Itemインスタンスをラップし、getterで出力する際に文字列にXMLエスケープを施します。
 * 
 * @since 1.2.7
 * @author Tomohiro Otsuka
 * @version $Id: ItemWrapper.java 197 2005-08-10 01:43:23Z otsuka $
 */
public class ItemWrapper implements Item {

	private Item i;

	public ItemWrapper(Item item) {
		super();
		this.i = item;
	}

	/**
	 * @see com.ozacc.blog.feed.Item#getDescription()
	 */
	public String getDescription() {
		return XmlUtils.escapeXml(i.getDescription());
	}

	/**
	 * @see com.ozacc.blog.feed.Item#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		i.setDescription(description);
	}

	/**
	 * @see com.ozacc.blog.feed.Item#getLink()
	 */
	public URL getLink() {
		return i.getLink();
	}

	/**
	 * @see com.ozacc.blog.feed.Item#setLink(java.net.URL)
	 */
	public void setLink(URL url) {
		i.setLink(url);
	}

	/**
	 * @see com.ozacc.blog.feed.Item#getTitle()
	 */
	public String getTitle() {
		return XmlUtils.escapeXml(i.getTitle());
	}

	/**
	 * @see com.ozacc.blog.feed.Item#setTitle(java.lang.String)
	 */
	public void setTitle(String title) {
		i.setTitle(title);
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getLanguage()
	 */
	public String getLanguage() {
		return XmlUtils.escapeXml(i.getLanguage());
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setLanguage(java.lang.String)
	 */
	public void setLanguage(String language) {
		i.setLanguage(language);
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getDate()
	 */
	public Date getDate() {
		return i.getDate();
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setDate(java.util.Date)
	 */
	public void setDate(Date date) {
		i.setDate(date);
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getCreator()
	 */
	public String getCreator() {
		return XmlUtils.escapeXml(i.getCreator());
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setCreator(java.lang.String)
	 */
	public void setCreator(String creator) {
		i.setCreator(creator);
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#getSubject()
	 */
	public String getSubject() {
		return XmlUtils.escapeXml(i.getSubject());
	}

	/**
	 * @see com.ozacc.blog.feed.DublinCoreMetadata#setSubject(java.lang.String)
	 */
	public void setSubject(String subject) {
		i.setSubject(subject);
	}

	/**
	 * @see com.ozacc.blog.feed.ContentMetadata#getEncoded()
	 */
	public String getEncoded() {
		return i.getEncoded();
	}

	/**
	 * @see com.ozacc.blog.feed.ContentMetadata#setEncoded(java.lang.String)
	 */
	public void setEncoded(String encoded) {
		i.setEncoded(encoded);
	}

}