package com.ozacc.blog.ping;

/**
 * 更新Pingを送信するクライアントのインターフェース。
 * <p>
 * 更新Pingの送信は、送信先サーバやネットワーク環境の状態によって
 * 容易に失敗し得る処理です。
 * UpdatePingExceptionは非チェック例外ですが、キャッチして失敗時の処理を
 * 考慮しておくのがベターです。
 * <p>
 * 更新Pingの送信については、非同期で送信するAsyncUpdatePingClientの使用をお薦めします。
 * 
 * @see AsyncUpdatePingClient
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: UpdatePingClient.java 180 2005-07-22 09:26:25Z otsuka $
 */
public interface UpdatePingClient {

	/**
	 * 更新Pingを送信します。<br>
	 * 送信に成功すると、サーバからのメッセージを返します。
	 * 失敗した場合には、UpdatePingExceptionをスローします。
	 * 
	 * @param pingUrl 更新Ping受付URL
	 * @param blogName 自分の log名
	 * @param blogUrl 自分のBlog URL
	 * @return サーバからのメッセージ
	 * @throws UpdatePingException Pingに失敗した場合
	 */
	String ping(String pingUrl, String blogName, String blogUrl) throws UpdatePingException;

	/**
	 * 指定された更新Pingを送信します。<br>
	 * 送信に成功すると、サーバからのメッセージを返します。
	 * 失敗した場合には、UpdatePingExceptionをスローします。
	 * <p>
	 * 更新Pingのパラメータには、UpdatePingオブジェクトを使用するので、
	 * Blog名とBlog URL以外に送信する必要がある場合は、
	 * UpdatePingにパラメータを追加してください。
	 * 
	 * @param pingUrl 更新Ping受付URL
	 * @param ping 更新Ping
	 * @return サーバからのメッセージ
	 * @throws UpdatePingException Pingに失敗した場合
	 */
	String ping(String pingUrl, UpdatePing ping) throws UpdatePingException;

}