package com.ozacc.blog.trackback;

/**
 * トラックバック先サーバへの接続に失敗した時にスローされる例外。
 * トラックバックURLが正しくない場合や、トラックバック先サーバが接続を受け付けない場合が該当します。
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: ConnectionException.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class ConnectionException extends TrackBackException {

	/**
	 * @param message 
	 */
	public ConnectionException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause 
	 */
	public ConnectionException(String message, Throwable cause) {
		super(message, cause);
	}

}