package com.ozacc.blog.trackback;

/**
 * トラックバックの送信自体は正常に行われたが、送信先サーバからエラーメッセージが返された場合にスローされる例外。
 * <code>getMessage()</code>メソッドで、返されたエラーメッセージを取得できます。
 * 
 * @since 1.0.1
 * @author Tomohiro Otsuka
 * @version $Id: FailedTrackBackException.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class FailedTrackBackException extends TrackBackException {

	/**
	 * @param message 
	 */
	public FailedTrackBackException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause 
	 */
	public FailedTrackBackException(String message, Throwable cause) {
		super(message, cause);
	}

}