package com.ozacc.blog.trackback;

import java.net.URL;

/**
 * トラックバックPing URLの自動検出。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: TrackBackAutoDiscovery.java 180 2005-07-22 09:26:25Z otsuka $
 */
public interface TrackBackAutoDiscovery {

	/**
	 * 指定されたURLのページに埋め込まれたトラックバックPing URLを自動的に検出します。
	 * 
	 * @param targetPageUrl ターゲットとするページのURL
	 * @return 検出したトラックバックPing URL。
	 * 1ページに複数埋め込まれている場合、全てのURLを返します。
	 * 検出できなかった場合は空のURL配列を返します。
	 * 
	 * @throws TrackBackException 指定されたURLへの接続に失敗した場合やPing URLが不正なフォーマットだった場合
	 */
	URL[] discoverTrackBackUrls(URL targetPageUrl) throws TrackBackException;

	/**
	 * 指定されたURLのページに埋め込まれたトラックバックPing URLを自動的に検出します。
	 * 
	 * @param targetPageUrl ターゲットとするページのURL
	 * @return 検出したトラックバックPing URL。
	 * 1ページに複数埋め込まれている場合、全てのURLを返します。
	 * 検出できなかった場合は空のURL配列を返します。
	 * 
	 * @throws TrackBackException 指定されたURLへの接続に失敗した場合やPing URLが不正なフォーマットだった場合
	 */
	URL[] discoverTrackBackUrls(String targetPageUrl) throws TrackBackException;

}