package com.ozacc.blog.trackback.impl;

import java.net.MalformedURLException;
import java.net.URL;

import com.ozacc.blog.trackback.AsyncTrackBackClient;
import com.ozacc.blog.trackback.TrackBackCallbackHandler;
import com.ozacc.blog.trackback.TrackBackException;
import com.ozacc.blog.trackback.TrackBackPing;

/**
 * AsyncTrackBackClientインターフェースの実装クラス。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: AsyncTrackBackClientImpl.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class AsyncTrackBackClientImpl extends TrackBackClientImpl implements AsyncTrackBackClient {

	/**
	 * コンストラクタ。
	 */
	public AsyncTrackBackClientImpl() {
		super();
	}

	/**
	 * コンストラクタ。<br>
	 * このクライアントのユーザーエージェント名をセットします。
	 * この値はPing送信先サーバのアクセスログに残る可能性があります。
	 * 
	 * @param userAgent ユーザーエージェント名
	 */
	public AsyncTrackBackClientImpl(String userAgent) {
		super(userAgent);
	}

	/**
	 * @see com.ozacc.blog.trackback.AsyncTrackBackClient#ping(java.net.URL, com.ozacc.blog.trackback.TrackBackPing, com.ozacc.blog.trackback.TrackBackCallbackHandler)
	 */
	public void ping(final URL trackBackPingUrl, final TrackBackPing ping,
						final TrackBackCallbackHandler handler) {
		Thread t = new Thread() {

			public void run() {
				try {
					ping(trackBackPingUrl, ping);
				} catch (TrackBackException e) {
					handler.handleError(trackBackPingUrl.toString(), ping, e);
					return;
				}
				handler.handleResult(trackBackPingUrl.toString(), ping);
			}
		};
		t.start();
	}

	/**
	 * @see com.ozacc.blog.trackback.AsyncTrackBackClient#ping(java.lang.String, com.ozacc.blog.trackback.TrackBackPing, com.ozacc.blog.trackback.TrackBackCallbackHandler)
	 */
	public void ping(String trackBackPingUrl, TrackBackPing ping, TrackBackCallbackHandler handler) {
		try {
			ping(new URL(trackBackPingUrl), ping, handler);
		} catch (MalformedURLException e) {
			TrackBackException ex = new TrackBackException("指定されたトラックバックURLが不正です。[TrackBackURL='"
					+ trackBackPingUrl + "'", e);
			handler.handleError(trackBackPingUrl, ping, ex);
		}
	}

}