package com.ozacc.blog.trackback.support.impl;

import javax.servlet.http.HttpServletRequest;

import com.ozacc.blog.trackback.TrackBackPing;
import com.ozacc.blog.trackback.support.CharsetResolver;

/**
 * 常にデフォルトの文字コード「UTF-8」を返すCharsetResolver実装クラス。
 * 
 * @since 1.2.3
 * @author Tomohiro Otsuka
 * @version $Id: DefaultCharsetResolver.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class DefaultCharsetResolver implements CharsetResolver {

	/**
	 * 受信したトラックバックにcharsetパラメータで文字コードがセットされていなかった場合に
	 * 使用するデフォルトの文字コード。
	 */
	private static final String DEFAULT_CHARSET = "UTF-8";

	/**
	 * @see com.ozacc.blog.trackback.support.CharsetResolver#resolveCharset(com.ozacc.blog.trackback.TrackBackPing, javax.servlet.http.HttpServletRequest)
	 */
	public String resolveCharset(TrackBackPing ping, HttpServletRequest request) {
		return DEFAULT_CHARSET;
	}

}