package com.ozacc.blog.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * ISO-8601に準じた日時表記フォーマッター。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: DateFormat.java 180 2005-07-22 09:26:25Z otsuka $
 */
public class DateFormat {

	/**
	 * ISO-8601に準じた日時表記を返します。
	 * (例 1997-07-16T19:20:30+01:00)
	 * 
	 * @param date
	 * @return 日時表記
	 */
	public static String format(Date date) {
		SimpleDateFormat formatter = getSimpleDateFormat();
		String result = formatter.format(date);
		String a = result.substring(0, result.length() - 2);
		String b = result.substring(result.length() - 2);
		return a + ":" + b;
	}

	/**
	 * ISO-8601に準じた日時表記の文字列からDateインスタンスを取得します。
	 * 
	 * @param date ISO-8601に準じた日時表記
	 * @return Dateインスタンス
	 * @throws ParseException
	 */
	public static Date parse(String date) throws ParseException {
		SimpleDateFormat formatter = getSimpleDateFormat();
		String d = date.substring(0, date.lastIndexOf(':'))
				+ date.substring(date.lastIndexOf(':') + 1);
		return formatter.parse(d);
	}

	/**
	 * @return ISO-8601パターンのSimpleDateFormat
	 */
	private static SimpleDateFormat getSimpleDateFormat() {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
		return formatter;
	}
}